/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.NXCPMessage;
import org.netxms.client.topology.Port;

public class VlanInfo {
    private int vlanId;
    private String name;
    private Port[] ports;
    private long nextFieldId;

    public VlanInfo(NXCPMessage msg, long baseId) {
        this.vlanId = msg.getFieldAsInt32(baseId);
        this.name = msg.getFieldAsString(baseId + 1L);
        int count = msg.getFieldAsInt32(baseId + 2L);
        this.ports = new Port[count];
        long fieldId = baseId + 3L;
        int i = 0;
        while (i < count) {
            int ifIndex = msg.getFieldAsInt32(fieldId++);
            long objectId = msg.getFieldAsInt64(fieldId++);
            int chassis = msg.getFieldAsInt32(fieldId++);
            int module = msg.getFieldAsInt32(fieldId++);
            int pic = msg.getFieldAsInt32(fieldId++);
            int port = msg.getFieldAsInt32(fieldId++);
            this.ports[i] = new Port(objectId, ifIndex, chassis, module, pic, port);
            ++i;
        }
        this.nextFieldId = fieldId;
    }

    public long getNextFieldId() {
        return this.nextFieldId;
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public String getName() {
        return this.name;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public boolean containsPort(int chassis, int module, int pic, int port) {
        Port[] portArray = this.ports;
        int n = this.ports.length;
        int n2 = 0;
        while (n2 < n) {
            Port p = portArray[n2];
            if (p.getChassis() == chassis && p.getModule() == module && p.getPIC() == pic && p.getPort() == port) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

