/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.ServerAction;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.dialogs.helpers.ActionComparator;
import org.netxms.ui.eclipse.epp.dialogs.helpers.ActionListFilter;

public class ActionSelectionDialog
extends Dialog {
    private boolean multiSelection;
    private Text filterText;
    private TableViewer eventList;
    private Collection<ServerAction> actions;
    private ServerAction[] selectedActions;
    private ActionListFilter filter;

    public ActionSelectionDialog(Shell parentShell, Collection<ServerAction> actions) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.actions = actions;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ActionSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectAction.cx"), settings.getInt("SelectAction.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.ActionSelectionDialog_Filter);
        this.filterText = new Text(dialogArea, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String filterString = settings.get("SelectAction.Filter");
        if (filterString != null) {
            this.filterText.setText(filterString);
        }
        this.eventList = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 4) | 0x100 | 0x200);
        this.eventList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eventList.setComparator((ViewerComparator)new ActionComparator());
        this.eventList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.filter = new ActionListFilter();
        if (filterString != null) {
            this.filter.setFilterString(filterString);
        }
        this.eventList.addFilter((ViewerFilter)this.filter);
        this.eventList.setInput((Object)this.actions.toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 350;
        this.eventList.getTable().setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionSelectionDialog.this.filter.setFilterString(ActionSelectionDialog.this.filterText.getText());
                ActionSelectionDialog.this.eventList.refresh();
            }
        });
        this.eventList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ActionSelectionDialog.this.okPressed();
            }
        });
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.eventList.getSelection();
        List list = selection.toList();
        this.selectedActions = list.toArray(new ServerAction[list.size()]);
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectAction.cx", size.x);
        settings.put("SelectAction.cy", size.y);
        settings.put("SelectAction.Filter", this.filterText.getText());
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public ServerAction[] getSelectedActions() {
        return this.selectedActions;
    }
}

