/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.TimeFrame;
import org.netxms.ui.eclipse.epp.dialogs.TimeFrameEditorDialog;
import org.netxms.ui.eclipse.epp.propertypages.helpers.TimeFrameLabelProvider;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;

public class RuleTimeFilter
extends PropertyPage {
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private List<TimeFrame> frames = new ArrayList<TimeFrame>();
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button checkInverted;

    protected Control createContents(Composite parent) {
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        this.checkInverted = new Button(dialogArea, 32);
        this.checkInverted.setText("Inverse rule (match time that is NOT within time frames listed below)");
        this.checkInverted.setSelection(this.rule.isTimeFramesInverted());
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TimeFrameLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)RuleTimeFilter.this.viewer.getSelection()).size();
                RuleTimeFilter.this.deleteButton.setEnabled(size > 0);
                RuleTimeFilter.this.editButton.setEnabled(size == 1);
            }
        });
        this.frames.addAll(this.rule.getTimeFrames());
        this.viewer.setInput(this.frames);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 0;
        gd.horizontalSpan = 1;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RuleTimeFilter.this.editFrame();
            }
        });
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleTimeFilter.this.addFrame();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText("&Edit...");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleTimeFilter.this.editFrame();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete");
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleTimeFilter.this.deleteFrame();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        return dialogArea;
    }

    private void addFrame() {
        TimeFrameEditorDialog dlg = new TimeFrameEditorDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            this.frames.add(dlg.getTimeFrame());
            this.viewer.setInput(this.frames);
        }
    }

    private void editFrame() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            TimeFrame element = (TimeFrame)selection.getFirstElement();
            TimeFrameEditorDialog dlg = new TimeFrameEditorDialog(this.getShell(), element);
            if (dlg.open() == 0) {
                this.viewer.update((Object)element, null);
            }
        }
    }

    private void deleteFrame() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                TimeFrame e = (TimeFrame)it.next();
                this.frames.remove(e);
            }
            this.viewer.setInput(this.frames);
        }
    }

    private void doApply() {
        int flags = this.rule.getFlags();
        flags = this.checkInverted.getSelection() && !this.frames.isEmpty() ? (flags |= 0x8000) : (flags &= 0xFFFF7FFF);
        this.rule.setFlags(flags);
        this.rule.setTimeFrames(this.frames);
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

