/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AbstractChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.BarChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GaugeConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LineChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.PieChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ScriptedBarChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ScriptedPieChartConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.perfview.widgets.YAxisRangeEditor;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class AbstractChart
extends PropertyPage {
    private AbstractChartConfig config;
    private TitleConfigurator title;
    private Spinner timeRange;
    private Combo timeUnits;
    private LabeledSpinner refreshRate;
    private Combo legendPosition;
    private Button checkShowLegend;
    private Button checkExtendedLegend;
    private Button checkShowGrid;
    private Button checkTranslucent;
    private Button checkTransposed;
    private Button checkDoughnutRendering;
    private Button checkShowTotal;
    private Button checkLogScale;
    private Button checkUseMultipliers;
    private Button checkStacked;
    private Button checkAreaChart;
    private Button checkInteractive;
    private LabeledSpinner lineWidth;
    private YAxisRangeEditor yAxisRange;
    private ObjectSelector drillDownObject;

    protected Control createContents(Composite parent) {
        this.config = (AbstractChartConfig)this.getElement().getAdapter(AbstractChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        Messages.get();
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.AbstractChart_LegendPosition, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Left);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Right);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Top);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Bottom);
        this.legendPosition.select(AbstractChart.positionIndexFromValue(this.config.getLegendPosition()));
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.AbstractChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = this.config instanceof LineChartConfig ? 3 : 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowLegend.setText(Messages.AbstractChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        if (!(this.config instanceof GaugeConfig)) {
            this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkExtendedLegend.setText(Messages.AbstractChart_ExtendedLegend);
            this.checkExtendedLegend.setSelection(this.config.isExtendedLegend());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkExtendedLegend.setLayoutData((Object)gd);
        }
        if (this.config instanceof LineChartConfig) {
            this.checkUseMultipliers = new Button((Composite)optionsGroup, 32);
            this.checkUseMultipliers.setText("Use &multipliers");
            this.checkUseMultipliers.setSelection(((LineChartConfig)this.config).isUseMultipliers());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkUseMultipliers.setLayoutData((Object)gd);
            this.checkLogScale = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkLogScale.setText(Messages.AbstractChart_LogartithmicScale);
            this.checkLogScale.setSelection(((LineChartConfig)this.config).isLogScaleEnabled());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkLogScale.setLayoutData((Object)gd);
            this.checkStacked = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkStacked.setText(Messages.AbstractChart_Stacked);
            this.checkStacked.setSelection(((LineChartConfig)this.config).isStacked());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkStacked.setLayoutData((Object)gd);
            this.checkAreaChart = new Button((Composite)optionsGroup, 32);
            this.checkAreaChart.setText("&Area chart");
            this.checkAreaChart.setSelection(((LineChartConfig)this.config).isArea());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkAreaChart.setLayoutData((Object)gd);
        }
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkTranslucent.setText(Messages.AbstractChart_Translucent);
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        if (this.config instanceof BarChartConfig || this.config instanceof ScriptedBarChartConfig) {
            this.checkTransposed = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkTransposed.setText(Messages.AbstractChart_Transposed);
            this.checkTransposed.setSelection(this.config instanceof BarChartConfig ? ((BarChartConfig)this.config).isTransposed() : ((ScriptedBarChartConfig)this.config).isTransposed());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkTransposed.setLayoutData((Object)gd);
        }
        if (this.config instanceof PieChartConfig || this.config instanceof ScriptedPieChartConfig) {
            this.checkDoughnutRendering = new Button((Composite)optionsGroup, 32);
            this.checkDoughnutRendering.setText("&Doughnut rendering");
            this.checkDoughnutRendering.setSelection(this.config instanceof PieChartConfig ? ((PieChartConfig)this.config).isDoughnutRendering() : ((ScriptedPieChartConfig)this.config).isDoughnutRendering());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkDoughnutRendering.setLayoutData((Object)gd);
            this.checkShowTotal = new Button((Composite)optionsGroup, 32);
            this.checkShowTotal.setText("Show &total");
            this.checkShowTotal.setSelection(this.config instanceof PieChartConfig ? ((PieChartConfig)this.config).isShowTotal() : ((ScriptedPieChartConfig)this.config).isShowTotal());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkShowTotal.setLayoutData((Object)gd);
        }
        if (this.config instanceof LineChartConfig) {
            this.checkShowGrid = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkShowGrid.setText(Messages.AbstractChart_ShowGrid);
            this.checkShowGrid.setSelection(((LineChartConfig)this.config).isShowGrid());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkShowGrid.setLayoutData((Object)gd);
            this.checkInteractive = new Button((Composite)optionsGroup, 32);
            this.checkInteractive.setText("&Interactive");
            this.checkInteractive.setSelection(((LineChartConfig)this.config).isInteractive());
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            this.checkInteractive.setLayoutData((Object)gd);
            Composite timeRangeArea = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 5;
            timeRangeArea.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            timeRangeArea.setLayoutData((Object)gd);
            Messages.get();
            this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeRangeArea, (int)2048, (String)Messages.AbstractChart_TimeInterval, (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
            this.timeRange.setSelection(((LineChartConfig)this.config).getTimeRange());
            Messages.get();
            this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeRangeArea, (int)8, (String)Messages.AbstractChart_TimeUnits, (Object)"WidgetHelper::default_layout_data");
            Messages.get();
            this.timeUnits.add(Messages.AbstractChart_Minutes);
            Messages.get();
            this.timeUnits.add(Messages.AbstractChart_Hours);
            Messages.get();
            this.timeUnits.add(Messages.AbstractChart_Days);
            this.timeUnits.select(((LineChartConfig)this.config).getTimeUnits());
        }
        Composite rateAndWidthArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = this.config instanceof LineChartConfig ? 2 : 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        layout.makeColumnsEqualWidth = true;
        rateAndWidthArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        rateAndWidthArea.setLayoutData((Object)gd);
        this.refreshRate = new LabeledSpinner(rateAndWidthArea, 0);
        Messages.get();
        this.refreshRate.setLabel(Messages.AbstractChart_RefreshInterval);
        this.refreshRate.setRange(1, 10000);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate.setLayoutData((Object)gd);
        if (this.config instanceof LineChartConfig) {
            this.lineWidth = new LabeledSpinner(rateAndWidthArea, 0);
            Messages.get();
            this.lineWidth.setLabel(Messages.AbstractChart_LineWidth);
            this.lineWidth.setRange(1, 32);
            this.lineWidth.setSelection(((LineChartConfig)this.config).getLineWidth());
            gd = new GridData();
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.lineWidth.setLayoutData((Object)gd);
        }
        if (!(this.config instanceof PieChartConfig) && !(this.config instanceof ScriptedPieChartConfig)) {
            this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.yAxisRange.setLayoutData((Object)gd);
            this.yAxisRange.setSelection(this.config.isAutoScale(), this.config.modifyYBase(), this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        }
        if (!(this.config instanceof LineChartConfig)) {
            this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
            this.drillDownObject.setLabel("Drill-down object");
            this.drillDownObject.setObjectClass(AbstractObject.class);
            this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
            this.drillDownObject.setObjectId(this.config.getDrillDownObjectId());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.drillDownObject.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    private static int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        if (!(this.config instanceof GaugeConfig)) {
            this.config.setExtendedLegend(this.checkExtendedLegend.getSelection());
        }
        if (this.config instanceof PieChartConfig) {
            ((PieChartConfig)this.config).setDoughnutRendering(this.checkDoughnutRendering.getSelection());
            ((PieChartConfig)this.config).setShowTotal(this.checkShowTotal.getSelection());
        } else if (this.config instanceof ScriptedPieChartConfig) {
            ((ScriptedPieChartConfig)this.config).setDoughnutRendering(this.checkDoughnutRendering.getSelection());
            ((ScriptedPieChartConfig)this.config).setShowTotal(this.checkShowTotal.getSelection());
        } else {
            if (!this.yAxisRange.validate(true)) {
                return false;
            }
            this.config.setAutoScale(this.yAxisRange.isAuto());
            this.config.setMinYScaleValue(this.yAxisRange.getMinY());
            this.config.setMaxYScaleValue(this.yAxisRange.getMaxY());
            this.config.setModifyYBase(this.yAxisRange.modifyYBase());
        }
        if (this.config instanceof BarChartConfig) {
            ((BarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        } else if (this.config instanceof ScriptedBarChartConfig) {
            ((ScriptedBarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        }
        if (this.config instanceof LineChartConfig) {
            ((LineChartConfig)this.config).setTimeRange(this.timeRange.getSelection());
            ((LineChartConfig)this.config).setTimeUnits(this.timeUnits.getSelectionIndex());
            ((LineChartConfig)this.config).setShowGrid(this.checkShowGrid.getSelection());
            ((LineChartConfig)this.config).setLogScaleEnabled(this.checkLogScale.getSelection());
            ((LineChartConfig)this.config).setUseMultipliers(this.checkUseMultipliers.getSelection());
            ((LineChartConfig)this.config).setStacked(this.checkStacked.getSelection());
            ((LineChartConfig)this.config).setArea(this.checkAreaChart.getSelection());
            ((LineChartConfig)this.config).setInteractive(this.checkInteractive.getSelection());
            ((LineChartConfig)this.config).setLineWidth(this.lineWidth.getSelection());
        } else {
            this.config.setDrillDownObjectId(this.drillDownObject.getObjectId());
        }
        return true;
    }
}

