/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;

public class EditPaneWidget
extends Composite {
    private static final RGB BACKGROUND_COLOR = new RGB(0, 0, 127);
    private DashboardControl dbc;
    private DashboardElement element;
    private Action actionEdit;
    private Action actionEditXml;
    private Action actionDuplicate;
    private Action actionDelete;
    private Action actionMoveLeft;
    private Action actionMoveRight;
    private Action actionHSpanIncrease;
    private Action actionHSpanDecrease;
    private Action actionHSpanFull;
    private Action actionVSpanIncrease;
    private Action actionVSpanDecrease;

    public EditPaneWidget(Composite parent, DashboardControl dbc, DashboardElement element) {
        super(parent, 0x40040000);
        Color color;
        this.dbc = dbc;
        this.element = element;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        if (Platform.getOS().equals("win32")) {
            color = new Color((Device)this.getDisplay(), BACKGROUND_COLOR);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    Point size = EditPaneWidget.this.getSize();
                    gc.setBackground(color);
                    gc.setAlpha(20);
                    gc.fillRectangle(0, 0, size.x, size.y);
                }
            });
        } else {
            color = new Color((Device)this.getDisplay(), BACKGROUND_COLOR, 20);
            this.setBackground(color);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                color.dispose();
            }
        });
        this.createActions();
        this.createContextMenu();
        this.createToolBar();
    }

    private void createActions() {
        Messages.get();
        this.actionEdit = new Action(Messages.EditPaneWidget_Edit, SharedIcons.EDIT){

            public void run() {
                EditPaneWidget.this.dbc.editElement(EditPaneWidget.this.element);
            }
        };
        Messages.get();
        this.actionEditXml = new Action(Messages.EditPaneWidget_EditXML, SharedIcons.XML){

            public void run() {
                EditPaneWidget.this.dbc.editElementXml(EditPaneWidget.this.element);
            }
        };
        this.actionDuplicate = new Action("Duplicate", Activator.getImageDescriptor("icons/duplicate.png")){

            public void run() {
                EditPaneWidget.this.dbc.duplicateElement(EditPaneWidget.this.element);
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.EditPaneWidget_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                EditPaneWidget.this.dbc.deleteElement(EditPaneWidget.this.element);
            }
        };
        this.actionMoveLeft = new Action("Move &left", Activator.getImageDescriptor("icons/move-left.png")){

            public void run() {
                EditPaneWidget.this.dbc.moveElement(EditPaneWidget.this.element, 16384);
            }
        };
        this.actionMoveRight = new Action("Move &right", Activator.getImageDescriptor("icons/move-right.png")){

            public void run() {
                EditPaneWidget.this.dbc.moveElement(EditPaneWidget.this.element, 131072);
            }
        };
        this.actionHSpanIncrease = new Action("Increase horizontal span", Activator.getImageDescriptor("icons/h-span-increase.png")){

            public void run() {
                EditPaneWidget.this.dbc.changeElementSpan(EditPaneWidget.this.element, 1, 0);
            }
        };
        this.actionHSpanDecrease = new Action("Decrease horizontal span", Activator.getImageDescriptor("icons/h-span-decrease.png")){

            public void run() {
                EditPaneWidget.this.dbc.changeElementSpan(EditPaneWidget.this.element, -1, 0);
            }
        };
        this.actionHSpanFull = new Action("&Full horizontal span", Activator.getImageDescriptor("icons/full-width.png")){

            public void run() {
                EditPaneWidget.this.dbc.setElementFullHSpan(EditPaneWidget.this.element);
            }
        };
        this.actionVSpanIncrease = new Action("Increase vertical span", Activator.getImageDescriptor("icons/v-span-increase.png")){

            public void run() {
                EditPaneWidget.this.dbc.changeElementSpan(EditPaneWidget.this.element, 0, 1);
            }
        };
        this.actionVSpanDecrease = new Action("Decrease vertical span", Activator.getImageDescriptor("icons/v-span-decrease.png")){

            public void run() {
                EditPaneWidget.this.dbc.changeElementSpan(EditPaneWidget.this.element, 0, -1);
            }
        };
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditPaneWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this);
        this.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionMoveLeft);
        manager.add((IAction)this.actionMoveRight);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHSpanIncrease);
        manager.add((IAction)this.actionHSpanDecrease);
        manager.add((IAction)this.actionHSpanFull);
        manager.add((IAction)this.actionVSpanIncrease);
        manager.add((IAction)this.actionVSpanDecrease);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionEditXml);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IAction)this.actionDelete);
    }

    private void createToolBar() {
        Composite buttonBar = new Composite((Composite)this, 2048);
        buttonBar.setBackground(this.getDisplay().getSystemColor(22));
        buttonBar.setLayout((Layout)new RowLayout());
        buttonBar.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        new ControlButton(buttonBar, this.actionMoveLeft);
        new ControlButton(buttonBar, this.actionMoveRight);
        new Label(buttonBar, 0).setText("\u2003");
        new ControlButton(buttonBar, this.actionHSpanIncrease);
        new ControlButton(buttonBar, this.actionHSpanDecrease);
        new ControlButton(buttonBar, this.actionHSpanFull);
        new ControlButton(buttonBar, this.actionVSpanIncrease);
        new ControlButton(buttonBar, this.actionVSpanDecrease);
        new Label(buttonBar, 0).setText("\u2003");
        new ControlButton(buttonBar, this.actionEdit);
        new ControlButton(buttonBar, this.actionEditXml);
        new ControlButton(buttonBar, this.actionDuplicate);
        new ControlButton(buttonBar, this.actionDelete);
        this.layout(true, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.getParent().getSize();
    }

    private static class ControlButton
    extends Canvas {
        private Image image;
        private boolean highlight = false;
        private boolean mouseDown = false;

        ControlButton(Composite parent, final Action action) {
            super(parent, 0);
            this.setToolTipText(action.getText());
            final Color highlightColor = this.getDisplay().getSystemColor(20);
            this.image = action.getImageDescriptor().createImage();
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    image.dispose();
                }
            });
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (highlight) {
                        Rectangle rect = this.getClientArea();
                        e.gc.setBackground(highlightColor);
                        e.gc.fillRoundRectangle(0, 0, rect.width, rect.height, 8, 8);
                    }
                    e.gc.drawImage(image, 2, 2);
                }
            });
            this.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    if (!highlight) {
                        highlight = true;
                        this.redraw();
                    }
                }

                public void mouseExit(MouseEvent e) {
                    if (highlight) {
                        highlight = false;
                        this.redraw();
                    }
                    mouseDown = false;
                }

                public void mouseHover(MouseEvent e) {
                    if (!highlight) {
                        highlight = true;
                        this.redraw();
                    }
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (mouseDown) {
                        mouseDown = false;
                        action.run();
                    }
                }

                public void mouseDown(MouseEvent e) {
                    mouseDown = true;
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!mouseDown && !highlight) {
                        return;
                    }
                    Rectangle bounds = this.getBounds();
                    if (e.x < 0 || e.y < 0 || e.x > bounds.width || e.y > bounds.height) {
                        mouseDown = false;
                        if (highlight) {
                            highlight = false;
                            this.redraw();
                        }
                    }
                }
            });
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Rectangle r = this.image.getBounds();
            return new Point(wHint == -1 ? r.width + 4 : wHint, hHint == -1 ? r.height + 4 : hHint);
        }
    }
}

