/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class LabelConfig
extends DashboardElementConfig {
    @Element(required=false)
    private String foreground = null;
    @Element(required=false)
    private String background = null;

    public static LabelConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        LabelConfig config = (LabelConfig)serializer.read(LabelConfig.class, xml);
        if (config.foreground != null && config.foreground.startsWith("0x")) {
            try {
                config.setTitleForeground(ColorConverter.rgbToCss((RGB)ColorConverter.rgbFromInt((int)Integer.parseInt(config.foreground.substring(2), 16))));
            }
            catch (NumberFormatException e) {
                Activator.logError("Cannot convert label foreground color \"" + config.foreground + "\"", e);
            }
            config.foreground = null;
        }
        if (config.background != null && config.background.startsWith("0x")) {
            try {
                config.setTitleBackground(ColorConverter.rgbToCss((RGB)ColorConverter.rgbFromInt((int)Integer.parseInt(config.background.substring(2), 16))));
            }
            catch (NumberFormatException e) {
                Activator.logError("Cannot convert label background color \"" + config.background + "\"", e);
            }
            config.background = null;
        }
        return config;
    }
}

