/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.client.ScriptCompilationResult;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.Activator;
import org.netxms.ui.eclipse.nxsl.Messages;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.NXFindAndReplaceAction;

public class ScriptEditorView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptEditorView";
    private static final Color ERROR_COLOR = new Color((Device)Display.getDefault(), 255, 0, 0);
    private NXCSession session;
    private ScriptEditor editor;
    private long scriptId;
    private String scriptName;
    private Action actionRefresh;
    private Action actionSave;
    private Action actionCompile;
    private Action actionShowLineNumbers;
    private Action actionGoToLine;
    private Action actionSelectAll;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;
    private FindReplaceAction actionFindReplace;
    private boolean modified = false;
    private boolean showLineNumbers = true;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.scriptId = Long.parseLong(site.getSecondaryId());
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get("ScriptEditor.showLineNumbers") != null) {
            this.showLineNumbers = settings.getBoolean("ScriptEditor.showLineNumbers");
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.editor = new ScriptEditor(parent, 0, 768, this.showLineNumbers, false);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ScriptEditorView.this.modified) {
                    ScriptEditorView.this.modified = true;
                    ScriptEditorView.this.firePropertyChange(257);
                    ScriptEditorView.this.actionSave.setEnabled(true);
                    ScriptEditorView.this.actionFindReplace.update();
                    boolean selected = ScriptEditorView.this.editor.getTextWidget().getSelectionCount() > 0;
                    ScriptEditorView.this.actionCut.setEnabled(selected);
                    ScriptEditorView.this.actionCopy.setEnabled(selected);
                }
            }
        });
        this.editor.getTextWidget().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = ScriptEditorView.this.editor.getTextWidget().getSelectionCount() > 0;
                ScriptEditorView.this.actionCut.setEnabled(selected);
                ScriptEditorView.this.actionCopy.setEnabled(selected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.reloadScript();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.nxsl.context.ScriptEditor");
        }
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionFindReplace = NXFindAndReplaceAction.getFindReplaceAction((ViewPart)this);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ScriptEditorView.this.reloadScript();
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.ScriptEditorView_Save, SharedIcons.SAVE){

            public void run() {
                ScriptEditorView.this.saveScript();
            }
        };
        this.actionSave.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.save");
        handlerService.activateHandler(this.actionSave.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSave));
        Messages.get();
        this.actionCompile = new Action(Messages.ScriptEditorView_Compile, Activator.getImageDescriptor("icons/compile.gif")){

            public void run() {
                ScriptEditorView.this.editor.compileScript();
            }
        };
        this.actionCompile.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.compile");
        handlerService.activateHandler(this.actionCompile.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCompile));
        Messages.get();
        this.actionShowLineNumbers = new Action(Messages.ScriptEditorView_ShowLineNumbers, 2){

            public void run() {
                ScriptEditorView.this.showLineNumbers = ScriptEditorView.this.actionShowLineNumbers.isChecked();
                ScriptEditorView.this.editor.showLineNumbers(ScriptEditorView.this.showLineNumbers);
            }
        };
        this.actionShowLineNumbers.setChecked(this.showLineNumbers);
        this.actionShowLineNumbers.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.showLineNumbers");
        handlerService.activateHandler(this.actionShowLineNumbers.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowLineNumbers));
        Messages.get();
        this.actionGoToLine = new Action(Messages.ScriptEditorView_GoToLine){

            public void run() {
                ScriptEditorView.this.goToLine();
            }
        };
        this.actionGoToLine.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.goToLine");
        handlerService.activateHandler(this.actionGoToLine.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionGoToLine));
        Messages.get();
        this.actionSelectAll = new Action(Messages.ScriptEditorView_SelectAll){

            public void run() {
                ScriptEditorView.this.editor.getTextWidget().selectAll();
            }
        };
        this.actionSelectAll.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.selectAll");
        handlerService.activateHandler(this.actionSelectAll.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSelectAll));
        Messages.get();
        this.actionCut = new Action(Messages.ScriptEditorView_Cut, SharedIcons.CUT){

            public void run() {
                ScriptEditorView.this.editor.getTextWidget().cut();
            }
        };
        this.actionCut.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.cut");
        handlerService.activateHandler(this.actionCut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCut));
        this.actionCut.setEnabled(false);
        Messages.get();
        this.actionCopy = new Action(Messages.ScriptEditorView_Copy, SharedIcons.COPY){

            public void run() {
                ScriptEditorView.this.editor.getTextWidget().copy();
            }
        };
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.copy");
        handlerService.activateHandler(this.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopy));
        this.actionCopy.setEnabled(false);
        Messages.get();
        this.actionPaste = new Action(Messages.ScriptEditorView_Paste, SharedIcons.PASTE){

            public void run() {
                ScriptEditorView.this.editor.getTextWidget().paste();
            }
        };
        this.actionPaste.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.paste");
        handlerService.activateHandler(this.actionPaste.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionPaste));
        this.actionPaste.setEnabled(this.canPaste());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFindReplace);
        manager.add((IAction)this.actionGoToLine);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IAction)this.actionSelectAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowLineNumbers);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCompile);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCompile);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScriptEditorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.editor.getTextWidget());
        this.editor.getTextWidget().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.actionPaste.setEnabled(this.canPaste());
        manager.add((IAction)this.actionFindReplace);
        manager.add((IAction)this.actionGoToLine);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IAction)this.actionSelectAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowLineNumbers);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCompile);
        manager.add((IAction)this.actionSave);
    }

    private boolean canPaste() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        TransferData[] available = cb.getAvailableTypes();
        boolean enabled = false;
        int i = 0;
        while (i < available.length) {
            if (TextTransfer.getInstance().isSupportedType(available[i])) {
                enabled = true;
                break;
            }
            ++i;
        }
        cb.dispose();
        return enabled;
    }

    private void goToLine() {
        StyledText textControl = this.editor.getTextWidget();
        final int maxLine = textControl.getLineCount();
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.ScriptEditorView_GoToLine_DlgTitle, String.format(Messages.ScriptEditorView_EnterLineNumber, maxLine), Integer.toString(textControl.getLineAtOffset(textControl.getCaretOffset()) + 1), new IInputValidator(){

            public String isValid(String newText) {
                try {
                    int n = Integer.parseInt(newText);
                    if (n < 1 || n > maxLine) {
                        Messages.get();
                        return Messages.ScriptEditorView_NumberOutOfRange;
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    Messages.get();
                    return Messages.ScriptEditorView_InvalidNumber;
                }
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        int line = Integer.parseInt(dlg.getValue());
        textControl.setCaretOffset(textControl.getOffsetAtLine(line - 1));
    }

    private void reloadScript() {
        Messages.get();
        new ConsoleJob(String.format(Messages.ScriptEditorView_LoadJobTitle, this.scriptId), (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ScriptEditorView_LoadJobError, ScriptEditorView.this.scriptId);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Script script = ScriptEditorView.this.session.getScript(ScriptEditorView.this.scriptId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptEditorView.this.scriptName = script.getName();
                        ScriptEditorView scriptEditorView = ScriptEditorView.this;
                        Messages.get();
                        scriptEditorView.setPartName(String.format(Messages.ScriptEditorView_PartName, (this).ScriptEditorView.this.scriptName));
                        (this).ScriptEditorView.this.editor.setText(script.getSource());
                        (this).ScriptEditorView.this.actionSave.setEnabled(false);
                        (this).ScriptEditorView.this.actionFindReplace.update();
                        (this).ScriptEditorView.this.modified = false;
                        ScriptEditorView.this.firePropertyChange(257);
                    }
                });
            }
        }.start();
    }

    private void saveScript() {
        final String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        Messages.get();
        new ConsoleJob(Messages.ScriptEditorView_SaveJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptEditorView_SaveJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ScriptCompilationResult result = ScriptEditorView.this.session.compileScript(source, false);
                if (result.success) {
                    this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ScriptEditorView.this.editor.hideMessage();
                            StyledText s = (this).ScriptEditorView.this.editor.getTextWidget();
                            s.setLineBackground(0, s.getLineCount(), null);
                        }
                    });
                } else {
                    this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = ScriptEditorView.this.getSite().getShell();
                            Messages.get();
                            Messages.get();
                            if (MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ScriptEditorView_CompilationErrors, (String)String.format(Messages.ScriptEditorView_ScriptCompilationFailed, result.errorMessage))) {
                                result.success = true;
                            }
                            (this).ScriptEditorView.this.editor.showMessage(1, result.errorMessage);
                            StyledText s = (this).ScriptEditorView.this.editor.getTextWidget();
                            s.setLineBackground(0, s.getLineCount(), null);
                            s.setLineBackground(result.errorLine - 1, 1, ERROR_COLOR);
                        }
                    });
                }
                if (result.success) {
                    ScriptEditorView.this.doScriptSave(source, monitor);
                } else {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).ScriptEditorView.this.editor.getTextWidget().setEditable(true);
                        }
                    });
                }
            }
        }.start();
    }

    private void doScriptSave(String source, IProgressMonitor monitor) throws Exception {
        this.session.modifyScript(this.scriptId, this.scriptName, source);
        this.editor.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ScriptEditorView.this.editor.isDisposed()) {
                    return;
                }
                ScriptEditorView.this.editor.getTextWidget().setEditable(true);
                ScriptEditorView.this.actionSave.setEnabled(false);
                ScriptEditorView.this.modified = false;
                ScriptEditorView.this.firePropertyChange(257);
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return (T)object;
        }
        if (adapter.equals(IFindReplaceTarget.class)) {
            return (T)this.editor.getFindReplaceTarget();
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        try {
            this.doScriptSave(source, monitor);
        }
        catch (Exception e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScriptEditorView_Error, (String)String.format(Messages.ScriptEditorView_SaveErrorMessage, e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ScriptEditor.showLineNumbers", this.showLineNumbers);
        this.modified = false;
        this.firePropertyChange(257);
        super.dispose();
    }
}

