/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Sensor;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.widgets.SensorCommon;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SensorProperties
extends PropertyPage {
    private Sensor sensor;
    private SensorCommon commonData;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.sensor = (Sensor)this.getElement().getAdapter(Sensor.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.commonData = new SensorCommon(dialogArea, 0, null, this.sensor.getMacAddress().toString(), this.sensor.getDeviceClass(), this.sensor.getVendor(), this.sensor.getSerialNumber(), this.sensor.getDeviceAddress(), this.sensor.getMetaType(), this.sensor.getDescription(), this.sensor.getProxyId(), this.sensor.getCommProtocol());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.commonData.setLayoutData(gd);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        if (!this.commonData.validate()) {
            return false;
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.sensor.getObjectId());
        md.setMacAddress(this.commonData.getMacAddress());
        md.setDeviceClass(this.commonData.getDeviceClass());
        md.setVendor(this.commonData.getVendor());
        md.setSerialNumber(this.commonData.getSerial());
        md.setDeviceAddress(this.commonData.getDeviceAddress());
        md.setMetaType(this.commonData.getMetaType());
        md.setDescription(this.commonData.getDescription());
        md.setSensorProxy(this.commonData.getProxyNode());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SensorPolling_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SensorPolling_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SensorProperties.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.commonData.updateFields("", 0, "", "", "", "", "");
    }
}

