/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.base.VersionInfo;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class AboutDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(AboutDialog.class);

    public AboutDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("About NetXMS Management Client"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        Composite spacer = new Composite(dialogArea, 0);
        spacer.setBackground(ThemeEngine.getBackgroundColor((String)"Window.Header"));
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 6;
        spacer.setLayoutData((Object)gd);
        Label logo = new Label(dialogArea, 0);
        logo.setBackground(ThemeEngine.getBackgroundColor((String)"Window.Header"));
        Image image = ResourceManager.getImage((String)"icons/about.png");
        logo.setImage(image);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.grabExcessVerticalSpace = true;
        logo.setLayoutData((Object)gd);
        logo.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite textArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        textArea.setLayoutData((Object)gd);
        GridLayout textAreaLayout = new GridLayout();
        textAreaLayout.marginWidth = 8;
        textAreaLayout.marginHeight = 8;
        textAreaLayout.verticalSpacing = 10;
        textArea.setLayout((Layout)textAreaLayout);
        Text versionText = new Text(textArea, 10);
        versionText.setFont(JFaceResources.getBannerFont());
        versionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        textArea.setBackground(versionText.getBackground());
        NXCSession session = Registry.getSession();
        StringBuilder sb = new StringBuilder();
        sb.append("NetXMS Management Client Version ");
        sb.append(VersionInfo.version());
        sb.append("\nCopyright \u00a9 2003-2023 Raden Solutions");
        versionText.setText(sb.toString());
        Text detailsText = new Text(textArea, 10);
        detailsText.setLayoutData((Object)new GridData(4, 4, true, true));
        sb = new StringBuilder();
        sb.append("Connected to ");
        sb.append(session.getServerAddress());
        sb.append(" (");
        sb.append(session.getServerName());
        sb.append(") as ");
        sb.append(session.getUserName());
        sb.append("\nServer version: ");
        sb.append(session.getServerVersion());
        sb.append(" (build ");
        sb.append(session.getServerBuild());
        sb.append(")\nServer ID: ");
        sb.append(Long.toHexString(session.getServerId()));
        sb.append("\nJava version: ");
        sb.append(System.getProperty("java.version"));
        sb.append("\nJVM: ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append(' ');
        sb.append(System.getProperty("java.vm.version"));
        detailsText.setText(sb.toString());
        Label separator = new Label(dialogArea, 258);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        separator.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, this.i18n.tr("Close"), false);
    }
}

