/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.PackageDeployment;
import org.netxms.nxmc.modules.agentmanagement.views.PackageDeploymentMonitor;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentStatus;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentStatusComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentStatusLabelProvider;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.RefreshTimer;
import org.xnap.commons.i18n.I18n;

public class PackageDeploymentMonitor
extends ObjectView {
    private static I18n i18n = LocalizationHelper.getI18n(PackageDeploymentMonitor.class);
    public static final String ID = "PackageDeploymentMonitor";
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_STATUS = 1;
    public static final int COLUMN_ERROR = 2;
    private SortableTableViewer viewer;
    private long packageId;
    private Set<Long> applicableObjects;
    private Action actionRedeploy;
    private Action actionExportSelectionToCsv;
    private Action actionExportAllToCsv;
    private PackageDeployment listener;
    private RefreshTimer refreshTimer;

    public PackageDeploymentMonitor() {
        super(i18n.tr("Package Deployment Monitor"), ResourceManager.getImageDescriptor((String)"icons/object-views/package_deploy.gif"), ID + UUID.randomUUID().toString(), false);
    }

    public View cloneView() {
        PackageDeploymentMonitor view = (PackageDeploymentMonitor)super.cloneView();
        view.packageId = this.packageId;
        view.applicableObjects = this.applicableObjects;
        view.listener = this.listener;
        return view;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("Node"), i18n.tr("Status"), i18n.tr("Message")};
        int[] widths = new int[]{200, 110, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DeploymentStatusLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DeploymentStatusComparator());
        this.refreshTimer = new RefreshTimer(100, this.viewer.getControl(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.listener.addMonitor(this);
        this.createActions();
        this.createPopupMenu();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void viewStatusUpdate() {
        this.refreshTimer.execute();
    }

    private void createActions() {
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.actionExportSelectionToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionRedeploy = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void redeployPackages() {
        HashSet<Long> objects = new HashSet<Long>();
        Collection array = this.listener.getDeployments();
        for (DeploymentStatus obj : array) {
            if (obj.getStatus() != 4) continue;
            objects.add(obj.getNodeObject().getObjectId());
        }
        NXCSession session = Registry.getSession();
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRedeploy);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    public void setPackageId(long packageId) {
        this.packageId = packageId;
    }

    public void setApplicableObjects(Set<Long> objects) {
        this.applicableObjects = objects;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportSelectionToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void setPackageDeploymentListener(PackageDeployment listener) {
        this.listener = listener;
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof AbstractObject) {
            Iterator iterator = this.applicableObjects.iterator();
            while (iterator.hasNext()) {
                long objectId = (Long)iterator.next();
                if (!((AbstractObject)context).isChildOf(objectId) && ((AbstractObject)context).getObjectId() != objectId) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCloseable() {
        return true;
    }

    public void dispose() {
        this.listener.removeMonitor(this);
        super.dispose();
    }

    public void deploymentComplete() {
        this.getWindow().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

