/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.dialogs.SelectAssetAttributeDlg;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectAssetAttributeDlg
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(SelectAssetAttributeDlg.class);
    private SortableTableViewer viewer;
    private List<AssetAttribute> selectedAttributes;

    public SelectAssetAttributeDlg(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Asset Attributes");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("Display name")};
        int[] widths = new int[]{200, 300};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttributeListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 300;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setInput(Registry.getSession().getAssetManagementSchema().values());
        this.viewer.packColumns();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select at least one attribute"));
            return;
        }
        this.selectedAttributes = new ArrayList(selection.size());
        for (Object o : selection.toList()) {
            this.selectedAttributes.add((AssetAttribute)o);
        }
        super.okPressed();
    }

    public List<AssetAttribute> getSelectedAttributes() {
        return this.selectedAttributes;
    }
}

