/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.TableValueConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.datacollection.widgets.TemplateDciSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TableValue
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(TableValue.class);
    private TableValueConfig config;
    private DciSelector dciSelector;
    private TemplateDciSelector dciName;
    private TemplateDciSelector dciDescription;
    private TitleConfigurator title;
    private Spinner refreshRate;

    public TableValue(DashboardElementConfig elementConfig) {
        super(i18n.tr("Table Value"), elementConfig);
    }

    public String getId() {
        return "table-value";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof TableValueConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (TableValueConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.dciSelector = new DciSelector(dialogArea, 0, true);
        this.dciSelector.setLabel(i18n.tr("Table DCI"));
        this.dciSelector.setDcObjectType(2);
        this.dciSelector.setDciId(this.config.getObjectId(), this.config.getDciId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dciSelector.setLayoutData((Object)gd);
        this.dciSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dciName = new TemplateDciSelector(dialogArea, 0);
        this.dciName.setLabel(i18n.tr("DCI Name"));
        this.dciName.setText(this.config.getDciName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.dciName.setLayoutData((Object)gd);
        this.dciName.setEnabled(this.config.getObjectId() == 0xFFFFFFFFL);
        this.dciDescription = new TemplateDciSelector(dialogArea, 0);
        this.dciDescription.setLabel(i18n.tr("DCI Description"));
        this.dciDescription.setText(this.config.getDciDescription());
        this.dciDescription.setSelectDescription(true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.dciDescription.setLayoutData((Object)gd);
        this.dciDescription.setEnabled(this.config.getObjectId() == 0xFFFFFFFFL);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Refresh interval (seconds)"), (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.dciSelector.getNodeId());
        this.config.setDciId(this.dciSelector.getDciId());
        this.config.setDciName(this.dciName.getText());
        this.config.setDciDescription(this.dciDescription.getText());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        return true;
    }
}

