/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.nxmc.base.widgets.ExtendedColorSelector;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.views.helpers.PerfViewGraphSettings;
import org.netxms.nxmc.modules.datacollection.widgets.YAxisRangeEditor;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class PerformanceView
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(PerformanceView.class);
    private DataCollectionItem dci;
    private PerfViewGraphSettings settings;
    private Button checkShow;
    private Button checkLogScale;
    private Button checkStacked;
    private Button checkShowLegendAlways;
    private Button checkExtendedLegend;
    private Button checkUseMultipliers;
    private Button checkInvertValues;
    private Button checkTranslucent;
    private LabeledText title;
    private LabeledText name;
    private ExtendedColorSelector color;
    private Combo type;
    private Spinner orderNumber;
    private Button checkShowThresholds;
    private LabeledText groupName;
    private Spinner timeRange;
    private Combo timeUnits;
    private YAxisRangeEditor yAxisRange;

    public PerformanceView(DataCollectionObjectEditor editor) {
        super(i18n.tr("Performance View"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        try {
            this.settings = PerfViewGraphSettings.createFromXml((String)this.dci.getPerfTabSettings());
        }
        catch (Exception e) {
            this.settings = new PerfViewGraphSettings();
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        this.checkShow = new Button(dialogArea, 32);
        this.checkShow.setText(i18n.tr("&Show in performance view"));
        this.checkShow.setSelection(this.settings.isEnabled());
        GridData gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShow.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel(i18n.tr("Title"));
        this.title.setText(this.settings.getTitle());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.title.setLayoutData((Object)gd);
        this.groupName = new LabeledText(dialogArea, 0);
        this.groupName.setLabel(i18n.tr("Group"));
        this.groupName.setText(this.settings.getGroupName());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.groupName.setLayoutData((Object)gd);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Name in legend"));
        this.name.setText(this.settings.getName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.name.setLayoutData((Object)gd);
        Group timeGroup = new Group(dialogArea, 0);
        timeGroup.setText(i18n.tr("Time Period"));
        GridLayout timeGroupLayout = new GridLayout();
        timeGroupLayout.makeColumnsEqualWidth = true;
        timeGroupLayout.numColumns = 2;
        timeGroup.setLayout((Layout)timeGroupLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        timeGroup.setLayoutData((Object)gd);
        this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeGroup, (int)2048, (String)i18n.tr("Time interval"), (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
        this.timeRange.setSelection(this.settings.getTimeRange());
        this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeGroup, (int)8, (String)i18n.tr("Time units"), (Object)"WidgetHelper::default_layout_data");
        this.timeUnits.add(i18n.tr("Minutes"));
        this.timeUnits.add(i18n.tr("Hours"));
        this.timeUnits.add(i18n.tr("Days"));
        this.timeUnits.select(this.settings.getTimeUnits());
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 3;
        gd.verticalAlignment = 4;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowThresholds = new Button((Composite)optionsGroup, 32);
        this.checkShowThresholds.setText(i18n.tr("&Show thresholds on graph"));
        this.checkShowThresholds.setSelection(this.settings.isShowThresholds());
        this.checkLogScale = new Button((Composite)optionsGroup, 32);
        this.checkLogScale.setText(i18n.tr("Logarithmic scale"));
        this.checkLogScale.setSelection(this.settings.isLogScaleEnabled());
        this.checkStacked = new Button((Composite)optionsGroup, 32);
        this.checkStacked.setText(i18n.tr("&Stacked"));
        this.checkStacked.setSelection(this.settings.isStacked());
        this.checkShowLegendAlways = new Button((Composite)optionsGroup, 32);
        this.checkShowLegendAlways.setText(i18n.tr("Always show &legend"));
        this.checkShowLegendAlways.setSelection(this.settings.isShowLegendAlways());
        this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
        this.checkExtendedLegend.setText(i18n.tr("&Extended legend"));
        this.checkExtendedLegend.setSelection(this.settings.isExtendedLegend());
        this.checkUseMultipliers = new Button((Composite)optionsGroup, 32);
        this.checkUseMultipliers.setText(i18n.tr("Use &multipliers"));
        this.checkUseMultipliers.setSelection(this.settings.isUseMultipliers());
        this.checkInvertValues = new Button((Composite)optionsGroup, 32);
        this.checkInvertValues.setText(i18n.tr("&Inverted values"));
        this.checkInvertValues.setSelection(this.settings.isInvertedValues());
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText(i18n.tr("&Translucent"));
        this.checkTranslucent.setSelection(this.settings.isTranslucent());
        this.color = new ExtendedColorSelector(dialogArea);
        this.color.setLabels(i18n.tr("Color"), i18n.tr("Automatic"), i18n.tr("Custom"));
        this.color.setColorValue(this.settings.isAutomaticColor() ? null : ColorConverter.rgbFromInt((int)this.settings.getColorAsInt()));
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.verticalAlignment = 4;
        this.color.setLayoutData((Object)gd);
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Type"), (Object)new GridData(4, 128, false, false));
        this.type.add(i18n.tr("Line"));
        this.type.add(i18n.tr("Area"));
        this.type.select(this.settings.getType());
        this.orderNumber = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Order"), (int)0, (int)65535, (Object)new GridData(4, 128, false, false));
        this.orderNumber.setSelection(this.settings.getOrder());
        this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.yAxisRange.setLayoutData((Object)gd);
        this.yAxisRange.setSelection(this.settings.isAutoScale(), this.settings.modifyYBase(), this.settings.getMinYScaleValue(), this.settings.getMaxYScaleValue());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.yAxisRange.validate(true)) {
            return false;
        }
        this.settings.setEnabled(this.checkShow.getSelection());
        this.settings.setLogScaleEnabled(this.checkLogScale.getSelection());
        this.settings.setTitle(this.title.getText());
        this.settings.setName(this.name.getText());
        this.settings.setType(this.type.getSelectionIndex());
        this.settings.setOrder(this.orderNumber.getSelection());
        this.settings.setGroupName(this.groupName.getText().trim());
        this.settings.setShowThresholds(this.checkShowThresholds.getSelection());
        this.settings.setStacked(this.checkStacked.getSelection());
        this.settings.setShowLegendAlways(this.checkShowLegendAlways.getSelection());
        this.settings.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.settings.setUseMultipliers(this.checkUseMultipliers.getSelection());
        this.settings.setInvertedValues(this.checkInvertValues.getSelection());
        this.settings.setTranslucent(this.checkTranslucent.getSelection());
        this.settings.setAutoScale(this.yAxisRange.isAuto());
        this.settings.setMinYScaleValue(this.yAxisRange.getMinY());
        this.settings.setMaxYScaleValue(this.yAxisRange.getMaxY());
        this.settings.setModifyYBase(this.yAxisRange.modifyYBase());
        this.settings.setTimeRange(this.timeRange.getSelection());
        this.settings.setTimeUnits(this.timeUnits.getSelectionIndex());
        RGB rgb = this.color.getColorValue();
        if (rgb != null) {
            this.settings.setAutomaticColor(false);
            this.settings.setColor(ColorConverter.rgbToInt((RGB)rgb));
        } else {
            this.settings.setAutomaticColor(true);
        }
        try {
            this.dci.setPerfTabSettings(this.settings.createXml());
        }
        catch (Exception e) {
            this.dci.setPerfTabSettings(null);
        }
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        PerfViewGraphSettings defaults = new PerfViewGraphSettings();
        this.checkShow.setSelection(defaults.isEnabled());
        this.title.setText(defaults.getTitle());
        this.color.setColorValue(ColorConverter.rgbFromInt((int)defaults.getColorAsInt()));
        this.groupName.setText("");
        this.orderNumber.setSelection(100);
    }
}

