/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ScriptEditorView
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(ScriptEditorView.class);
    private NXCSession session;
    private ScriptEditor editor;
    private long scriptId;
    private String scriptName;
    private boolean modified = false;
    private boolean showLineNumbers = true;
    private Action actionSave;
    private Action actionCompile;
    private Action actionShowLineNumbers;
    private Action actionGoToLine;
    private Action actionSelectAll;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;

    public ScriptEditorView(long scriptId, String scriptName) {
        super(scriptName, ResourceManager.getImageDescriptor((String)"icons/config-views/script-editor.png"), "ScriptEditor." + Long.toString(scriptId), false);
        this.scriptId = scriptId;
        this.scriptName = scriptName;
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        this.editor = new ScriptEditor(parent, 0, 768, this.showLineNumbers, false);
        this.editor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editor.getTextWidget().addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionCompile = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F2", (IAction)this.actionCompile);
        this.actionShowLineNumbers = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLineNumbers.setChecked(this.showLineNumbers);
        this.addKeyBinding("M1+M3+L", (IAction)this.actionShowLineNumbers);
        this.actionGoToLine = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+G", (IAction)this.actionGoToLine);
        this.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+A", (IAction)this.actionSelectAll);
        this.actionCut = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCut.setEnabled(false);
        this.addKeyBinding("M1+X", (IAction)this.actionCut);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionPaste = new /* Unavailable Anonymous Inner Class!! */;
        this.actionPaste.setEnabled(this.canPaste());
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.editor.getTextWidget());
        this.editor.getTextWidget().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionCopy);
        mgr.add((IAction)this.actionCut);
        mgr.add((IAction)this.actionPaste);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionSelectAll);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionCompile);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.actionCompile);
        manager.add((IAction)this.actionSave);
    }

    private boolean canPaste() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        TransferData[] available = WidgetHelper.getAvailableTypes((Clipboard)cb);
        boolean enabled = false;
        for (int i = 0; i < available.length; ++i) {
            if (!TextTransfer.getInstance().isSupportedType(available[i])) continue;
            enabled = true;
            break;
        }
        cb.dispose();
        return enabled;
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void saveScript() {
        String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void save() {
        String source = this.editor.getText();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void goToLine() {
        int maxLine = this.editor.getLineCount();
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), this.i18n.tr("Go to Line"), String.format(this.i18n.tr("Enter line number (1..%d)"), maxLine), Integer.toString(this.editor.getCurrentLine()), (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        this.editor.setCaretToLine(Integer.parseInt(dlg.getValue()));
    }

    public void setFocus() {
        if (!this.editor.isDisposed()) {
            this.editor.setFocus();
        }
    }

    public boolean isCloseable() {
        return true;
    }
}

