/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.RelatedObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectFilter;
import org.xnap.commons.i18n.I18n;

public class RelatedObjectSelectionDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(RelatedObjectSelectionDialog.class);
    private long seedObject;
    private RelationType relationType;
    private Set<Integer> classFilter;
    private ObjectFilter filter;
    private FilterText filterText;
    private TableViewer objectList;
    private List<AbstractObject> selectedObjects;

    public static Set<Integer> createClassFilter(int[] classes) {
        HashSet<Integer> filter = new HashSet<Integer>(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            filter.add(classes[i]);
        }
        return filter;
    }

    public static Set<Integer> createClassFilter(int c) {
        HashSet<Integer> filter = new HashSet<Integer>(1);
        filter.add(c);
        return filter;
    }

    public RelatedObjectSelectionDialog(Shell parentShell, long seedObject, RelationType relationType, Set<Integer> classFilter) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.seedObject = seedObject;
        this.relationType = relationType;
        this.classFilter = classFilter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.relationType == RelationType.DIRECT_SUBORDINATES ? this.i18n.tr("Select Subordinate Object") : this.i18n.tr("Select Parent Object"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("RelatedObjectSelectionDialog.cx", 300), settings.getAsInteger("RelatedObjectSelectionDialog.cy", 350));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        AbstractObject object = Registry.getSession().findObjectById(this.seedObject);
        AbstractObject[] sourceObjects = object != null ? (this.relationType == RelationType.DIRECT_SUBORDINATES ? object.getChildrenAsArray() : object.getParentsAsArray()) : new AbstractObject[]{};
        FillLayout dialogLayout = new FillLayout();
        dialogLayout.marginHeight = 10;
        dialogLayout.marginWidth = 10;
        dialogArea.setLayout((Layout)dialogLayout);
        Composite listArea = new Composite(dialogArea, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        listArea.setLayout((Layout)layout);
        this.filterText = new FilterText(listArea, 0, null, false, false);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.objectList = new TableViewer(listArea, 65538);
        this.objectList.getTable().setHeaderVisible(false);
        this.objectList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.objectList.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
        this.objectList.setComparator(new ViewerComparator());
        this.filter = new ObjectFilter(sourceObjects, this.classFilter);
        this.objectList.addFilter((ViewerFilter)this.filter);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.objectList.getControl().setLayoutData((Object)gd);
        this.objectList.setInput((Object)sourceObjects);
        this.objectList.getControl().setFocus();
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.objectList.getSelection();
        this.selectedObjects = new ArrayList(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.selectedObjects.add((AbstractObject)it.next());
        }
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("RelatedObjectSelectionDialog.cx", size.x);
        settings.set("RelatedObjectSelectionDialog.cy", size.y);
    }

    public List<AbstractObject> getSelectedObjects() {
        return this.selectedObjects;
    }
}

