/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkService;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.NetworkServiceFilter;
import org.netxms.nxmc.modules.objects.views.helpers.NetworkServiceListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.NetworkServiceListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NetworkServiceView
extends NodeSubObjectTableView {
    private static final I18n i18n = LocalizationHelper.getI18n(NetworkServiceView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_SERVICE_TYPE = 3;
    public static final int COLUMN_ADDRESS = 4;
    public static final int COLUMN_PORT = 5;
    public static final int COLUMN_REQUEST = 6;
    public static final int COLUMN_RESPONSE = 7;
    public static final int COLUMN_POLLER_NODE = 8;
    public static final int COLUMN_POLL_COUNT = 9;
    private NetworkServiceListLabelProvider labelProvider;

    public NetworkServiceView() {
        super(i18n.tr("Network Services"), ResourceManager.getImageDescriptor((String)"icons/object-views/network_service.png"), "Network Services", true);
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof AbstractNode) {
            return ((AbstractNode)context).hasNetworkServices();
        }
        return false;
    }

    public int getPriority() {
        return 70;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChildren(11).toArray());
        } else {
            this.viewer.setInput((Object)new NetworkService[0]);
        }
    }

    protected void createViewer() {
        String[] names = new String[]{"Id", "Name", "Status", "Service type", "Address", "Port", "Request", "Response", "Poller node", "Poll count"};
        int[] widths = new int[]{60, 150, 80, 80, 80, 80, 200, 200, 200, 80};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.labelProvider = new NetworkServiceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new NetworkServiceListComparator(this.labelProvider));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new NetworkServiceFilter(this.labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"NetworkService.V1");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof NetworkService && object.isChildOf(this.getObjectId());
    }
}

