/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class InterfaceListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final I18n i18n = LocalizationHelper.getI18n(InterfaceListLabelProvider.class);
    private final String[] ifaceExpectedState = new String[]{this.i18n.tr("Up"), this.i18n.tr("Down"), this.i18n.tr("Ignore"), this.i18n.tr("Auto")};
    private AbstractNode node = null;
    private NXCSession session = Registry.getSession();
    private TableViewer viewer;

    public InterfaceListLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.node == null) {
            return "";
        }
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 22: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xBackendStateAsText();
                }
                return null;
            }
            case 21: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xPaeStateAsText();
                }
                return null;
            }
            case 13: {
                return iface.getAdminStateAsText();
            }
            case 2: {
                return iface.getIfAlias();
            }
            case 4: {
                return iface.getDescription();
            }
            case 15: {
                return this.ifaceExpectedState[iface.getExpectedState()];
            }
            case 0: {
                return Long.toString(iface.getObjectId());
            }
            case 3: {
                return Integer.toString(iface.getIfIndex());
            }
            case 5: {
                return iface.getIpAddressListAsString();
            }
            case 7: {
                return this.session.getVendorByMac(iface.getMacAddress(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
            }
            case 6: {
                return iface.getMacAddress().toString();
            }
            case 9: {
                return Integer.toString(iface.getMtu());
            }
            case 1: {
                return iface.getObjectName();
            }
            case 14: {
                return iface.getOperStateAsText();
            }
            case 18: {
                return iface.isOSPF() ? iface.getOSPFArea().getHostAddress() : "";
            }
            case 20: {
                return iface.isOSPF() ? iface.getOSPFState().getText() : "";
            }
            case 19: {
                return iface.isOSPF() ? iface.getOSPFType().getText() : "";
            }
            case 24: {
                return this.getPeerInterfaceName(iface);
            }
            case 27: {
                return this.getPeerIpAddress(iface);
            }
            case 25: {
                MacAddress macAddr = this.getPeerMacAddress(iface);
                return macAddr != null ? macAddr.toString() : null;
            }
            case 26: {
                MacAddress macAddr = this.getPeerMacAddress(iface);
                return macAddr != null ? this.session.getVendorByMac(macAddr, (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element)) : null;
            }
            case 23: {
                return this.getPeerNodeName(iface);
            }
            case 28: {
                return this.getPeerProtocol(iface);
            }
            case 12: {
                if (iface.isPhysicalPort()) {
                    return iface.getPhysicalLocation();
                }
                return null;
            }
            case 10: {
                return iface.getSpeed() > 0L ? InterfaceListLabelProvider.ifSpeedTotext((long)iface.getSpeed()) : "";
            }
            case 17: {
                return StatusDisplayInfo.getStatusText((ObjectStatus)iface.getStatus());
            }
            case 16: {
                return iface.getStpPortState().getText();
            }
            case 11: {
                String typeName = iface.getIfTypeName();
                return typeName != null ? String.format("%d (%s)", iface.getIfType(), typeName) : Integer.toString(iface.getIfType());
            }
            case 8: {
                return InterfaceListLabelProvider.getVlanList((Interface)iface);
            }
        }
        return null;
    }

    private String getPeerIpAddress(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        if (peer == null) {
            return null;
        }
        if (!peer.getPrimaryIP().isValidUnicastAddress()) {
            return null;
        }
        return peer.getPrimaryIP().getHostAddress();
    }

    public MacAddress getPeerMacAddress(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getMacAddress() : null;
    }

    private String getPeerProtocol(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? iface.getPeerDiscoveryProtocol().toString() : null;
    }

    private String getPeerNodeName(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        return peer != null ? peer.getObjectName() : null;
    }

    private String getPeerInterfaceName(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getObjectName() : null;
    }

    public void setNode(AbstractNode node) {
        this.node = node;
    }

    public Color getForeground(Object element, int columnIndex) {
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 17: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)iface.getStatus());
            }
            case 14: {
                switch (iface.getOperState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)(iface.getAdminState() == 2 ? ObjectStatus.DISABLED : ObjectStatus.CRITICAL));
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.TESTING);
                    }
                    case 4: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.MINOR);
                    }
                    case 5: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
                    }
                }
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNKNOWN);
            }
            case 13: {
                switch (iface.getAdminState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.TESTING);
                    }
                }
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNKNOWN);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    private static String divideSpeed(long speed, int power) {
        int l;
        String s = Long.toString(speed);
        StringBuilder sb = new StringBuilder(s.substring(0, s.length() - power));
        char[] rem = s.substring(s.length() - power, s.length()).toCharArray();
        for (l = rem.length - 1; l >= 0 && rem[l] == '0'; --l) {
        }
        if (l >= 0) {
            sb.append('.');
            for (int i = 0; i <= l; ++i) {
                sb.append(rem[i]);
            }
        }
        return sb.toString();
    }

    public static String ifSpeedTotext(long speed) {
        if (speed < 1000L) {
            return Long.toString(speed) + " bps";
        }
        if (speed < 1000000L) {
            return InterfaceListLabelProvider.divideSpeed((long)speed, (int)3) + " Kbps";
        }
        if (speed < 1000000000L) {
            return InterfaceListLabelProvider.divideSpeed((long)speed, (int)6) + " Mbps";
        }
        if (speed < 1000000000000L) {
            return InterfaceListLabelProvider.divideSpeed((long)speed, (int)9) + " Gbps";
        }
        return InterfaceListLabelProvider.divideSpeed((long)speed, (int)12) + " Tbps";
    }

    public static String getVlanList(Interface iface) {
        long[] vlans = iface.getVlans();
        if (vlans.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(vlans[0]);
        for (int i = 1; i < vlans.length; ++i) {
            sb.append(", ");
            sb.append(vlans[i]);
        }
        return sb.toString();
    }
}

