/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.PhysicalLink;
import org.netxms.client.SessionListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.PhysicalLinkEditDialog;
import org.netxms.nxmc.modules.objects.views.helpers.PhysicalLinkComparator;
import org.netxms.nxmc.modules.objects.views.helpers.PhysicalLinkFilter;
import org.netxms.nxmc.modules.objects.views.helpers.PhysicalLinkLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class PhysicalLinkManager {
    public static final int COL_PHYSICAL_LINK_ID = 0;
    public static final int COL_DESCRIPTOIN = 1;
    public static final int COL_LEFT_OBJECT = 2;
    public static final int COL_LEFT_PORT = 3;
    public static final int COL_RIGHT_OBJECT = 4;
    public static final int COL_RIGHT_PORT = 5;
    private static final String TABLE_CONFIG_PREFIX = "PhysicalLinkView";
    private final I18n i18n = LocalizationHelper.getI18n(PhysicalLinkManager.class);
    private View view;
    private NXCSession session;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private PhysicalLinkFilter filter;
    private long objectId = 0L;
    private long patchPanelId = 0L;
    private Action actionAdd;
    private Action actionDelete;
    private Action actionEdit;

    public PhysicalLinkManager(View view, Composite parent) {
        this.view = view;
        this.session = Registry.getSession();
        int[] widths = new int[]{50, 200, 200, 400, 200, 400};
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Description"), this.i18n.tr("Object 1"), this.i18n.tr("Port 1"), this.i18n.tr("Object 2"), this.i18n.tr("Port 2")};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        PhysicalLinkLabelProvider labelPrivater = new PhysicalLinkLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelPrivater);
        this.viewer.setComparator((ViewerComparator)new PhysicalLinkComparator(labelPrivater));
        this.filter = new PhysicalLinkFilter(labelPrivater);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
        this.refresh();
    }

    public long getPatchPanelId() {
        return this.patchPanelId;
    }

    public void setPatchPanelId(long patchPanelId) {
        this.patchPanelId = patchPanelId;
        this.refresh();
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public PhysicalLinkFilter getFilter() {
        return this.filter;
    }

    private void createActions() {
        this.actionAdd = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdd.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    public void refresh() {
        if (this.objectId < 0L) {
            this.viewer.setInput((Object)new Object[0]);
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void syncAdditionalObjects(Collection<PhysicalLink> links) throws IOException, NXCException {
        ArrayList<Long> additionalSyncInterfaces = new ArrayList<Long>();
        for (PhysicalLink link : links) {
            long id = link.getLeftObjectId();
            if (id != 0L) {
                additionalSyncInterfaces.add(id);
            }
            if ((id = link.getRightObjectId()) == 0L) continue;
            additionalSyncInterfaces.add(id);
        }
        if (!additionalSyncInterfaces.isEmpty()) {
            this.session.syncMissingObjects(additionalSyncInterfaces, true, 2);
        }
    }

    private void editPhysicalLink() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        PhysicalLink link = (PhysicalLink)selection.getFirstElement();
        PhysicalLinkEditDialog dlg = new PhysicalLinkEditDialog(this.view.getWindow().getShell(), link);
        if (dlg.open() != 0) {
            return;
        }
        PhysicalLink editedLink = dlg.getLink();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deletePhysicalLink() {
        String message;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        String string = message = selection.size() == 1 ? this.i18n.tr("Do you really want to delete the selected physical link?") : this.i18n.tr("Do you really want to delete the selected physical links?");
        if (!MessageDialogHelper.openQuestion((Shell)this.view.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)message)) {
            return;
        }
        ArrayList<PhysicalLink> links = new ArrayList<PhysicalLink>(selection.size());
        for (Object o : selection.toList()) {
            links.add((PhysicalLink)o);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void addPhysicalLink() {
        PhysicalLinkEditDialog dlg = new PhysicalLinkEditDialog(this.view.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        PhysicalLink link = dlg.getLink();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

