/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.InputField;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.helpers.InputFieldLabelProvider;
import org.netxms.nxmc.modules.objecttools.dialogs.InputFieldEditDialog;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class InputFields
extends PropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(InputFields.class);
    private ObjectToolDetails objectTool;
    private List<InputField> fields = new ArrayList();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private Button buttonUp;
    private Button buttonDown;

    public InputFields(ObjectToolDetails toolDetails) {
        super(i18n.tr("Input Fields"));
        this.noDefaultAndApplyButton();
        this.objectTool = toolDetails;
    }

    protected Control createContents(Composite parent) {
        for (InputField f : this.objectTool.getInputFields()) {
            this.fields.add(new InputField(f));
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 540;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new InputFieldLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.setupTableColumns();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput((Object)this.fields.toArray());
        Composite buttonsLeft = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalIndent = 2;
        buttonsLeft.setLayoutData((Object)gd);
        this.buttonUp = new Button(buttonsLeft, 8);
        this.buttonUp.setText(i18n.tr("&Up"));
        this.buttonUp.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonUp.setLayoutData((Object)rd);
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(buttonsLeft, 8);
        this.buttonDown.setText(i18n.tr("&Down"));
        this.buttonDown.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonDown.setLayoutData((Object)rd);
        this.buttonDown.setEnabled(false);
        Composite buttonsRight = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttonsRight.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonsRight, 8);
        this.buttonAdd.setText(i18n.tr("&Add..."));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttonsRight, 8);
        this.buttonEdit.setText(i18n.tr("&Edit..."));
        this.buttonEdit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(buttonsRight, 8);
        this.buttonRemove.setText(i18n.tr("&Delete"));
        this.buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        return dialogArea;
    }

    private void setupTableColumns() {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(i18n.tr("Name"));
        column.setWidth(200);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(i18n.tr("Type"));
        column.setWidth(90);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText(i18n.tr("Display name"));
        column.setWidth(200);
        this.viewer.getTable().setHeaderVisible(true);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (String)"InputFieldsPropertyPage");
    }

    private void addField() {
        InputField f = new InputField("Field" + Integer.toString(this.fields.size() + 1));
        InputFieldEditDialog dlg = new InputFieldEditDialog(this.getShell(), true, f);
        if (dlg.open() == 0 && this.nameIsUnique(f.getName())) {
            f.setSequence(this.fields.size());
            this.fields.add(f);
            this.viewer.setInput((Object)this.fields.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)f));
        }
    }

    private boolean nameIsUnique(String name) {
        for (InputField f : this.fields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    private void editField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputFieldEditDialog dlg = new InputFieldEditDialog(this.getShell(), false, (InputField)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.viewer.update(selection.getFirstElement(), null);
        }
    }

    private void removeField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.fields.remove(it.next());
        }
        this.viewer.setInput((Object)this.fields.toArray());
    }

    private void moveFieldUp() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputField f = (InputField)selection.getFirstElement();
        if (f.getSequence() > 0) {
            this.updateSequence(f.getSequence() - 1, 1);
            f.setSequence(f.getSequence() - 1);
            this.viewer.refresh();
        }
    }

    private void moveFieldDown() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputField f = (InputField)selection.getFirstElement();
        if (f.getSequence() < this.fields.size() - 1) {
            this.updateSequence(f.getSequence() + 1, -1);
            f.setSequence(f.getSequence() + 1);
            this.viewer.refresh();
        }
    }

    private void updateSequence(int curr, int delta) {
        for (InputField f : this.fields) {
            if (f.getSequence() != curr) continue;
            f.setSequence(curr + delta);
            break;
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.objectTool.setInputFields((Collection)this.fields);
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)"InputFieldsPropertyPage");
        return true;
    }

    public boolean performCancel() {
        if (this.isControlCreated()) {
            WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (String)"InputFieldsPropertyPage");
        }
        return super.performCancel();
    }
}

