/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.snmp.helpers.SnmpValueLabelProvider;
import org.xnap.commons.i18n.I18n;

public class MibWalkDialog
extends Dialog
implements SnmpWalkListener {
    private static I18n i18n = LocalizationHelper.getI18n(MibWalkDialog.class);
    public static final int COLUMN_OID = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_VALUE = 2;
    private long nodeId;
    private SnmpObjectId rootObject;
    private SortableTableViewer viewer;
    private List<SnmpValue> walkData = new ArrayList();
    private SnmpValue value;

    public MibWalkDialog(Shell parentShell, long nodeId, SnmpObjectId rootObject) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.nodeId = nodeId;
        this.rootObject = rootObject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("MIB Walk Results"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsPoint("MibWalkDialog.size", 400, 250));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new SortableTableViewer(dialogArea, 67588);
        this.setupViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SnmpValueLabelProvider());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 600;
        gd.heightHint = 400;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void setupViewerColumns() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(i18n.tr("OID"));
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText("OID as text");
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(i18n.tr("Type"));
        tc.setWidth(100);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(i18n.tr("Value"));
        tc.setWidth(300);
    }

    public void create() {
        super.create();
        this.startWalk();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.value = (SnmpValue)selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("MibWalkDialog.size", size);
    }

    private void startWalk() {
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void onSnmpWalkData(long nodeId, List<SnmpValue> data) {
        this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public SnmpValue getValue() {
        return this.value;
    }

    static /* synthetic */ Button access$000(MibWalkDialog x0, int x1) {
        return x0.getButton(x1);
    }

    static /* synthetic */ Button access$100(MibWalkDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

