/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HardwareComponentCategory {
    OTHER(0),
    BASEBOARD(1),
    PROCESSOR(2),
    MEMORY_DEVICE(3),
    STORAGE_DEVICE(4),
    BATTERY(5),
    NETWORK_ADAPTER(6);

    private static Logger logger;
    private static Map<Integer, HardwareComponentCategory> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(HardwareComponentCategory.class);
        lookupTable = new HashMap<Integer, HardwareComponentCategory>();
        HardwareComponentCategory[] hardwareComponentCategoryArray = HardwareComponentCategory.values();
        int n = hardwareComponentCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            HardwareComponentCategory element = hardwareComponentCategoryArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private HardwareComponentCategory(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HardwareComponentCategory getByValue(int value) {
        HardwareComponentCategory element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return OTHER;
        }
        return element;
    }
}

