/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ObjectPollType {
    UNKNOWN(0),
    STATUS(1),
    CONFIGURATION_FULL(2),
    INTERFACES(3),
    TOPOLOGY(4),
    CONFIGURATION_NORMAL(5),
    INSTANCE_DISCOVERY(6),
    ROUTING_TABLE(7),
    NETWORK_DISCOVERY(8),
    AUTOBIND(9);

    private static Logger logger;
    private static Map<Integer, ObjectPollType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(ObjectPollType.class);
        lookupTable = new HashMap<Integer, ObjectPollType>();
        ObjectPollType[] objectPollTypeArray = ObjectPollType.values();
        int n = objectPollTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectPollType element = objectPollTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ObjectPollType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ObjectPollType getByValue(int value) {
        ObjectPollType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

