/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.objecttabs.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.UserSession;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserSessionComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        UserSession s1 = (UserSession)e1;
        UserSession s2 = (UserSession)e2;
        Integer id = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (id) {
            case 10: {
                result = Long.compare(s1.getAgentPID(), s2.getAgentPID());
                break;
            }
            case 9: {
                result = Integer.compare(s1.getAgentType(), s2.getAgentType());
                break;
            }
            case 5: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)s1.getClientAddress(), (InetAddress)s2.getClientAddress());
                break;
            }
            case 4: {
                result = s1.getClientName().compareToIgnoreCase(s2.getClientName());
                break;
            }
            case 6: {
                result = s1.getDisplayDescription().compareToIgnoreCase(s2.getDisplayDescription());
                break;
            }
            case 0: {
                result = Integer.compare(s1.getId(), s2.getId());
                break;
            }
            case 8: {
                result = Integer.compare(s1.getIdleTime(), s2.getIdleTime());
                break;
            }
            case 7: {
                result = s1.getLoginTime().compareTo(s2.getLoginTime());
                break;
            }
            case 2: {
                result = s1.getTerminal().compareToIgnoreCase(s2.getTerminal());
                break;
            }
            case 1: {
                result = s1.getLoginName().compareToIgnoreCase(s2.getLoginName());
                break;
            }
            case 3: {
                result = Boolean.compare(s1.isConnected(), s2.isConnected());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

