/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import org.netxms.base.NXCPMessage;

public class ActionExecutionConfiguration {
    private long actionId;
    private String timerDelay;
    private String snoozeTime;
    private String timerKey;
    private String blockingTimerKey;

    ActionExecutionConfiguration(long actionId) {
        this.actionId = actionId;
        this.timerDelay = null;
        this.snoozeTime = null;
        this.timerKey = null;
        this.blockingTimerKey = null;
    }

    public ActionExecutionConfiguration(long actionId, String timerDelay, String snoozeTime, String timerKey, String blockingTimerKey) {
        this.actionId = actionId;
        this.timerDelay = timerDelay;
        this.snoozeTime = snoozeTime;
        this.timerKey = timerKey;
        this.blockingTimerKey = blockingTimerKey;
    }

    protected ActionExecutionConfiguration(NXCPMessage msg, long baseId) {
        this.actionId = msg.getFieldAsInt64(baseId);
        this.timerDelay = msg.getFieldAsString(baseId + 1L);
        this.timerKey = msg.getFieldAsString(baseId + 2L);
        this.blockingTimerKey = msg.getFieldAsString(baseId + 3L);
        this.snoozeTime = msg.getFieldAsString(baseId + 4L);
    }

    public ActionExecutionConfiguration(ActionExecutionConfiguration src) {
        this.actionId = src.actionId;
        this.timerDelay = src.timerDelay;
        this.snoozeTime = src.snoozeTime;
        this.timerKey = src.timerKey;
        this.blockingTimerKey = src.blockingTimerKey;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt32(baseId, (int)this.actionId);
        msg.setField(baseId + 1L, this.timerDelay);
        msg.setField(baseId + 2L, this.timerKey);
        msg.setField(baseId + 3L, this.blockingTimerKey);
        msg.setField(baseId + 4L, this.snoozeTime);
    }

    public String getTimerDelay() {
        return this.timerDelay != null ? this.timerDelay : "";
    }

    public void setTimerDelay(String timerDelay) {
        this.timerDelay = timerDelay;
    }

    public String getTimerKey() {
        return this.timerKey != null ? this.timerKey : "";
    }

    public void setTimerKey(String timerKey) {
        this.timerKey = timerKey;
    }

    public long getActionId() {
        return this.actionId;
    }

    public String getBlockingTimerKey() {
        return this.blockingTimerKey != null ? this.blockingTimerKey : "";
    }

    public void setBlockingTimerKey(String blockingTimerKey) {
        this.blockingTimerKey = blockingTimerKey;
    }

    public String getSnoozeTime() {
        return this.snoozeTime != null ? this.snoozeTime : "";
    }

    public void setSnoozeTime(String snoozeTime) {
        this.snoozeTime = snoozeTime;
    }
}

