/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.objecttabs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.businessservices.BusinessServiceCheck;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.client.objects.interfaces.NodeItemPair;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.views.TabbedObjectView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.slm.Activator;
import org.netxms.ui.eclipse.slm.dialogs.EditBusinessServiceCheckDlg;
import org.netxms.ui.eclipse.slm.objecttabs.helpers.BusinessServiceCheckFilter;
import org.netxms.ui.eclipse.slm.objecttabs.helpers.BusinessServiceCheckLabelProvider;
import org.netxms.ui.eclipse.slm.objecttabs.helpers.BusinessServiceComparator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.RefreshTimer;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class BusinessServiceChecks
extends ObjectTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_OBJECT = 3;
    public static final int COLUMN_DCI = 4;
    public static final int COLUMN_STATUS = 5;
    public static final int COLUMN_FAIL_REASON = 6;
    public static final int COLUMN_ORIGIN = 7;
    private static final String CONFIG_PREFIX = "BusinessServiceChecks";
    private NXCSession session;
    private SessionListener sessionListener;
    private Composite content;
    private SortableTableViewer viewer;
    private FilterText filterText;
    private boolean filterEnabled;
    private BusinessServiceCheckLabelProvider labelProvider;
    private BusinessServiceCheckFilter filter;
    private Action actionEdit;
    private Action actionDuplicate;
    private Action actionCreate;
    private Action actionDelete;
    private Action actionShowObjectDetails;
    private long serviceId = 0L;
    private Map<Long, BusinessServiceCheck> checks;
    private Map<Long, BusinessServiceCheck> updatedChecks = new HashMap<Long, BusinessServiceCheck>();
    private Set<Long> deletedChecks = new HashSet<Long>();
    private RefreshTimer refreshTimer;

    protected void createTabContent(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusinessServiceChecks.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                BusinessServiceChecks.this.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.slm.commands.show_checks_filter");
                State state = command.getState("org.netxms.ui.eclipse.slm.commands.show_checks_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        });
        String[] names = new String[]{"ID", "Description", "Type", "Object", "DCI", "Status", "Reason", "Origin"};
        int[] widths = new int[]{70, 200, 100, 200, 200, 70, 300, 300};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 1024, -1);
        this.labelProvider = new BusinessServiceCheckLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setComparator((ViewerComparator)new BusinessServiceComparator(this.labelProvider));
        this.filter = new BusinessServiceCheckFilter(this.labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                BusinessServiceCheck check = new BusinessServiceCheck((BusinessServiceCheck)selection.getFirstElement());
                BusinessServiceChecks.this.actionEdit.setEnabled(selection.size() == 1 && check.getPrototypeServiceId() == 0L);
                BusinessServiceChecks.this.actionDuplicate.setEnabled(selection.size() == 1);
                BusinessServiceChecks.this.actionDelete.setEnabled(selection.size() > 0);
                BusinessServiceChecks.this.actionShowObjectDetails.setEnabled(selection.size() == 1);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.filterEnabled = settings.getBoolean("BusinessServiceChecks.EnableFilter");
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)settings, (String)"BusinessServiceChecks.TableSettings");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)BusinessServiceChecks.this.viewer.getTable(), (IDialogSettings)settings, (String)"BusinessServiceChecks.TableSettings");
                settings.put("BusinessServiceChecks.EnableFilter", BusinessServiceChecks.this.filterEnabled);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BusinessServiceChecks.this.actionEdit.run();
            }
        });
        this.createActions();
        this.createPopupMenu();
        this.refreshTimer = new RefreshTimer(300, this.viewer.getControl(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = BusinessServiceChecks.this.updatedChecks;
                synchronized (object) {
                    if (!BusinessServiceChecks.this.updatedChecks.isEmpty()) {
                        ArrayList<BusinessServiceCheck> newChecks = new ArrayList<BusinessServiceCheck>();
                        for (BusinessServiceCheck c : BusinessServiceChecks.this.updatedChecks.values()) {
                            newChecks.add(c);
                            BusinessServiceChecks.this.checks.put(c.getId(), c);
                        }
                        BusinessServiceChecks.this.updatedChecks.clear();
                        BusinessServiceChecks.this.updateDciLabels(newChecks);
                        BusinessServiceChecks.this.syncMissingObjects(newChecks);
                    }
                }
                object = BusinessServiceChecks.this.deletedChecks;
                synchronized (object) {
                    for (Long id : BusinessServiceChecks.this.deletedChecks) {
                        BusinessServiceChecks.this.checks.remove(id);
                    }
                    BusinessServiceChecks.this.deletedChecks.clear();
                }
                BusinessServiceChecks.this.viewer.refresh();
            }
        });
        this.sessionListener = new SessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1057) {
                    boolean needRefresh = false;
                    Map<Long, BusinessServiceCheck> map = BusinessServiceChecks.this.updatedChecks;
                    synchronized (map) {
                        BusinessServiceCheck check = (BusinessServiceCheck)n.getObject();
                        if (check.getServiceId() == BusinessServiceChecks.this.serviceId) {
                            BusinessServiceChecks.this.updatedChecks.put(n.getSubCode(), check);
                            needRefresh = true;
                        }
                    }
                    if (needRefresh) {
                        BusinessServiceChecks.this.refreshTimer.execute();
                    }
                } else if (n.getCode() == 1058) {
                    Set<Long> set = BusinessServiceChecks.this.deletedChecks;
                    synchronized (set) {
                        BusinessServiceChecks.this.deletedChecks.add(n.getSubCode());
                    }
                    BusinessServiceChecks.this.refreshTimer.execute();
                }
            }
        };
        this.session.addListener(this.sessionListener);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    private void createActions() {
        this.actionCreate = new Action("&New...", SharedIcons.ADD_OBJECT){

            public void run() {
                BusinessServiceChecks.this.createCheck();
            }
        };
        this.actionEdit = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                BusinessServiceChecks.this.editCheck();
            }
        };
        this.actionDuplicate = new Action("&Duplicate"){

            public void run() {
                BusinessServiceChecks.this.duplicateCheck();
            }
        };
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                BusinessServiceChecks.this.deleteCheck();
            }
        };
        this.actionShowObjectDetails = new Action("Show object details"){

            public void run() {
                BusinessServiceChecks.this.showObjectDetails();
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BusinessServiceChecks.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowObjectDetails);
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof BaseBusinessService;
    }

    public void selected() {
        super.selected();
        AbstractObject object = this.getObject();
        this.serviceId = object != null ? object.getObjectId() : 0L;
        this.refresh();
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.slm.commands.show_checks_filter");
        State state = command.getState("org.netxms.ui.eclipse.slm.commands.show_checks_filter.state");
        state.setValue((Object)this.filterEnabled);
        service.refreshElements(command.getId(), null);
    }

    public void objectChanged(AbstractObject object) {
        this.viewer.setInput((Object)new Object[0]);
        this.serviceId = object != null ? object.getObjectId() : 0L;
        this.refresh();
    }

    public void refresh() {
        final AbstractObject object = this.getObject();
        if (object == null) {
            return;
        }
        new ConsoleJob("Get business service checks", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map checks = BusinessServiceChecks.this.session.getBusinessServiceChecks(object.getObjectId());
                Object object2 = BusinessServiceChecks.this.updatedChecks;
                synchronized (object2) {
                    BusinessServiceChecks.this.updatedChecks.clear();
                }
                object2 = BusinessServiceChecks.this.deletedChecks;
                synchronized (object2) {
                    BusinessServiceChecks.this.deletedChecks.clear();
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).BusinessServiceChecks.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        (this).BusinessServiceChecks.this.checks = checks;
                        (this).BusinessServiceChecks.this.viewer.setInput(checks.values());
                        BusinessServiceChecks.this.syncMissingObjects(checks.values());
                        BusinessServiceChecks.this.updateDciLabels(checks.values());
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot get checks for business service %s", object.getObjectName());
            }
        }.start();
    }

    public void updateDciLabels(final Collection<BusinessServiceCheck> checks) {
        ConsoleJob job = new ConsoleJob("Resolve DCI names", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map names = BusinessServiceChecks.this.session.dciIdsToNames(checks);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).BusinessServiceChecks.this.viewer.getControl().isDisposed()) {
                            return;
                        }
                        (this).BusinessServiceChecks.this.labelProvider.updateDciNames(names);
                        (this).BusinessServiceChecks.this.viewer.refresh(true);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot resolve DCI names";
            }
        };
        job.setUser(false);
        job.start();
    }

    public void syncMissingObjects(final Collection<BusinessServiceCheck> checks) {
        ConsoleJob job = new ConsoleJob("Synchronize objects", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ArrayList<Long> relatedOpbjects = new ArrayList<Long>();
                for (NodeItemPair pair : checks) {
                    if (pair.getNodeId() == 0L) continue;
                    relatedOpbjects.add(pair.getNodeId());
                }
                BusinessServiceChecks.this.session.syncMissingObjects(relatedOpbjects, true, 2);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).BusinessServiceChecks.this.viewer.getControl().isDisposed()) {
                            (this).BusinessServiceChecks.this.viewer.refresh(true);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot synchronize objects";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected void deleteCheck() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getViewPart().getSite().getShell(), (String)"Confirm Delete", (String)"Do you really want to delete selected check?")) {
            return;
        }
        final BusinessServiceCheck[] checks = new BusinessServiceCheck[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            checks[i++] = (BusinessServiceCheck)o;
        }
        new ConsoleJob("Delete business service check", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < checks.length) {
                    BusinessServiceChecks.this.session.deleteBusinessServiceCheck(checks[i].getServiceId(), checks[i].getId());
                    ++i;
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete business service check";
            }
        }.start();
    }

    protected void duplicateCheck() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        final BusinessServiceCheck check = new BusinessServiceCheck((BusinessServiceCheck)selection.getFirstElement());
        if (selection.size() != 1) {
            return;
        }
        check.setId(0L);
        new ConsoleJob("Duplicate business service check", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                BusinessServiceChecks.this.session.modifyBusinessServiceCheck(BusinessServiceChecks.this.getObject().getObjectId(), check);
            }

            protected String getErrorMessage() {
                return "Cannot duplicate business service check";
            }
        }.start();
    }

    protected void editCheck() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        final BusinessServiceCheck check = new BusinessServiceCheck((BusinessServiceCheck)selection.getFirstElement());
        if (selection.size() != 1 || check.getPrototypeServiceId() != 0L) {
            return;
        }
        EditBusinessServiceCheckDlg dlg = new EditBusinessServiceCheckDlg(this.getViewPart().getSite().getShell(), check, false);
        if (dlg.open() == 0) {
            new ConsoleJob("Update business service check", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    BusinessServiceChecks.this.session.modifyBusinessServiceCheck(BusinessServiceChecks.this.getObject().getObjectId(), check);
                }

                protected String getErrorMessage() {
                    return "Cannot update business service check";
                }
            }.start();
        }
    }

    private void createCheck() {
        final BusinessServiceCheck check = new BusinessServiceCheck();
        EditBusinessServiceCheckDlg dlg = new EditBusinessServiceCheckDlg(this.getViewPart().getSite().getShell(), check, false);
        if (dlg.open() == 0) {
            new ConsoleJob("Create business service check", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    BusinessServiceChecks.this.session.modifyBusinessServiceCheck(BusinessServiceChecks.this.getObject().getObjectId(), check);
                }

                protected String getErrorMessage() {
                    return "Cannot create business service check";
                }
            }.start();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filter.setFilterString("");
            this.viewer.refresh(false);
        }
    }

    private void showObjectDetails() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        BusinessServiceCheck check = new BusinessServiceCheck((BusinessServiceCheck)selection.getFirstElement());
        if (check.getObjectId() == 0L) {
            return;
        }
        AbstractObject object = this.session.findObjectById(check.getObjectId());
        try {
            TabbedObjectView view = (TabbedObjectView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
            view.setObject(object);
        }
        catch (PartInitException e) {
            MessageDialogHelper.openError((Shell)this.viewer.getControl().getShell(), (String)"Error", (String)String.format("Error opening object details view: %s", e.getLocalizedMessage()));
        }
    }
}

