/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.views;

import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.LogRecordDetails;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.logviewer.Activator;
import org.netxms.ui.eclipse.logviewer.LogRecordDetailsViewer;
import org.netxms.ui.eclipse.logviewer.LogRecordDetailsViewerRegistry;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.views.helpers.LogLabelProvider;
import org.netxms.ui.eclipse.logviewer.widgets.FilterBuilder;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class LogViewer
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.logviewer.view.log_viewer";
    private static final int PAGE_SIZE = 400;
    protected NXCSession session;
    private FilterBuilder filterBuilder;
    protected TableViewer viewer;
    private String logName;
    private Log logHandle;
    private LogFilter filter;
    private LogFilter delayedQueryFilter = null;
    private LogRecordDetailsViewer recordDetailsViewer;
    private Image titleImage = null;
    private org.netxms.client.Table resultSet;
    private boolean noData = false;
    private Action actionRefresh;
    private Action actionExecute;
    private Action actionClearFilter;
    private Action actionShowFilter;
    private Action actionGetMoreData;
    private Action actionCopyToClipboard;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionShowDetails;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.logName = site.getSecondaryId();
        this.setPartName(Messages.getString("LogViewer_" + this.logName));
        ImageDescriptor img = Activator.getImageDescriptor("icons/" + this.logName + ".png");
        if (img != null) {
            this.titleImage = img.createImage();
            this.setTitleImage(this.titleImage);
        }
        this.filter = new LogFilter();
        this.recordDetailsViewer = LogRecordDetailsViewerRegistry.get(this.logName);
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
    }

    public void createPartControl(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.filterBuilder = new FilterBuilder(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.filterBuilder.setLayoutData(gd);
        this.viewer = new TableViewer(parent, 65538);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogViewer.this.showRecordDetails();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (LogViewer.this.logHandle != null) {
                    WidgetHelper.saveColumnSettings((Table)LogViewer.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("LogViewer." + LogViewer.this.logHandle.getName()));
                }
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterBuilder);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        table.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterBuilder.setLayoutData(fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        Messages.get();
        new ConsoleJob(String.format(Messages.LogViewer_OpenLogJobName, this.logName), (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer"){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.LogViewer_OpenLogError, LogViewer.this.logName);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Log handle = LogViewer.this.session.openServerLog(LogViewer.this.logName);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).LogViewer.this.logHandle = handle;
                        LogViewer.this.setupLogViewer();
                        if ((this).LogViewer.this.delayedQueryFilter != null) {
                            (this).LogViewer.this.filterBuilder.setFilter((this).LogViewer.this.delayedQueryFilter);
                            (this).LogViewer.this.delayedQueryFilter = null;
                            LogViewer.this.doQuery();
                        }
                    }
                });
            }
        }.start();
        this.activateContext();
    }

    protected void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.logviewer.context.LogViewer");
        }
    }

    protected int estimateColumnWidth(LogColumn lc) {
        switch (lc.getType()) {
            case 6: {
                return 80;
            }
            case 5: {
                return 120;
            }
            case 1: {
                return 100;
            }
            case 13: {
                return 100;
            }
            case 2: {
                return 150;
            }
            case 0: {
                return 250;
            }
        }
        return 100;
    }

    private void setupLogViewer() {
        Table table = this.viewer.getTable();
        Collection columns = this.logHandle.getColumns();
        for (LogColumn lc : columns) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(lc.getDescription());
            column.setData((Object)lc);
            column.setWidth(this.estimateColumnWidth(lc));
            if (lc.getType() != 5) continue;
            this.filterBuilder.addOrderingColumn(lc, true);
        }
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("LogViewer." + this.logHandle.getName()));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(this.logHandle));
        this.filterBuilder.setLogHandle(this.logHandle);
        this.filter = this.filterBuilder.createFilter();
    }

    protected ITableLabelProvider createLabelProvider(Log logHandle) {
        return new LogLabelProvider(logHandle, this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionGetMoreData);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearFilter);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionGetMoreData);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionClearFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LogViewer.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (this.recordDetailsViewer != null) {
            mgr.add((IAction)this.actionShowDetails);
            mgr.add((IContributionItem)new Separator());
        }
        mgr.add((IAction)this.actionCopyToClipboard);
        mgr.add((IAction)this.actionExportToCsv);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                LogViewer.this.refreshData();
            }
        };
        this.actionRefresh.setEnabled(false);
        Messages.get();
        this.actionExecute = new Action(Messages.LogViewer_ActionExec, SharedIcons.EXECUTE){

            public void run() {
                LogViewer.this.doQuery();
            }
        };
        this.actionExecute.setActionDefinitionId("org.netxms.ui.eclipse.logviewer.commands.execute");
        handlerService.activateHandler(this.actionExecute.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionExecute));
        Messages.get();
        this.actionClearFilter = new Action(Messages.LogViewer_ActionClearFilter, SharedIcons.CLEAR_LOG){

            public void run() {
                LogViewer.this.filterBuilder.clearFilter();
            }
        };
        Messages.get();
        this.actionGetMoreData = new Action(Messages.LogViewer_ActionGetMoreData, Activator.getImageDescriptor("icons/get_more_data.png")){

            public void run() {
                LogViewer.this.getMoreData();
            }
        };
        this.actionGetMoreData.setEnabled(false);
        this.actionGetMoreData.setActionDefinitionId("org.netxms.ui.eclipse.logviewer.commands.get_more_data");
        handlerService.activateHandler(this.actionGetMoreData.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionGetMoreData));
        Messages.get();
        this.actionShowFilter = new Action(Messages.LogViewer_ActionShowFilter, 2){

            public void run() {
                LogViewer.this.showFilter(LogViewer.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(true);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.logviewer.commands.show_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        Messages.get();
        this.actionCopyToClipboard = new Action(Messages.LogViewer_ActionCopy, SharedIcons.COPY){

            public void run() {
                LogViewer.this.copySelectionToClipboard();
            }
        };
        this.actionCopyToClipboard.setActionDefinitionId("org.netxms.ui.eclipse.library.commands.copy");
        handlerService.activateHandler(this.actionCopyToClipboard.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopyToClipboard));
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
        this.actionShowDetails = new Action("Show &details"){

            public void run() {
                LogViewer.this.showRecordDetails();
            }
        };
    }

    public void queryWithFilter(LogFilter filter) {
        if (this.logHandle != null) {
            this.filterBuilder.setFilter(filter);
            this.doQuery();
        } else {
            this.delayedQueryFilter = filter;
        }
    }

    private void doQuery() {
        this.actionRefresh.setEnabled(false);
        this.actionGetMoreData.setEnabled(false);
        this.filter = this.filterBuilder.createFilter();
        Messages.get();
        new ConsoleJob(Messages.LogViewer_QueryJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer"){

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.LogViewer_QueryJobError) + LogViewer.this.logName;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LogViewer.this.logHandle.query(LogViewer.this.filter);
                final org.netxms.client.Table data = LogViewer.this.logHandle.retrieveData(0L, 400L);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).LogViewer.this.resultSet = data;
                        (this).LogViewer.this.viewer.setInput((Object)(this).LogViewer.this.resultSet.getAllRows());
                        (this).LogViewer.this.noData = (this).LogViewer.this.resultSet.getRowCount() < 400;
                        (this).LogViewer.this.actionGetMoreData.setEnabled(!(this).LogViewer.this.noData);
                        (this).LogViewer.this.actionRefresh.setEnabled(true);
                    }
                });
            }
        }.start();
    }

    private void getMoreData() {
        if (this.noData) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.LogViewer_GetDataJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer"){

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.LogViewer_QueryError) + LogViewer.this.logName;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final org.netxms.client.Table data = LogViewer.this.logHandle.retrieveData((long)LogViewer.this.resultSet.getRowCount(), 400L);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).LogViewer.this.resultSet.addAll(data);
                        (this).LogViewer.this.viewer.setInput((Object)(this).LogViewer.this.resultSet.getAllRows());
                        (this).LogViewer.this.noData = data.getRowCount() < 400;
                        (this).LogViewer.this.actionGetMoreData.setEnabled(!(this).LogViewer.this.noData);
                    }
                });
            }
        }.start();
    }

    private void refreshData() {
        Messages.get();
        new ConsoleJob(Messages.LogViewer_RefreshJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer"){

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.LogViewer_RefreshError) + LogViewer.this.logName;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final org.netxms.client.Table data = LogViewer.this.logHandle.retrieveData(0L, (long)LogViewer.this.resultSet.getRowCount(), true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).LogViewer.this.resultSet = data;
                        (this).LogViewer.this.viewer.setInput((Object)(this).LogViewer.this.resultSet.getAllRows());
                    }
                });
            }
        }.start();
    }

    private void showRecordDetails() {
        if (this.recordDetailsViewer == null) {
            return;
        }
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final TableRow record = (TableRow)selection.getFirstElement();
        final long recordId = record.getValueAsLong(this.logHandle.getRecordIdColumnIndex());
        new ConsoleJob("Get log record details", (IWorkbenchPart)this, "org.netxms.ui.eclipse.logviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final LogRecordDetails recordDetails = LogViewer.this.logHandle.getRecordDetails(recordId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).LogViewer.this.recordDetailsViewer.showRecordDetails(recordDetails, record, (this).LogViewer.this.logHandle, (IViewPart)LogViewer.this);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get details for selected record";
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        super.dispose();
    }

    protected void showFilter(boolean show) {
        this.filterBuilder.setVisible(show);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = show ? new FormAttachment((Control)this.filterBuilder) : new FormAttachment(0, 0);
        this.viewer.getTable().getParent().layout();
        if (show) {
            this.filterBuilder.setFocus();
        }
    }

    private void copySelectionToClipboard() {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            StringBuilder sb = new StringBuilder();
            String newLine = WidgetHelper.getNewLineCharacters();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(0));
                int j = 1;
                while (j < this.viewer.getTable().getColumnCount()) {
                    sb.append('\t');
                    sb.append(selection[i].getText(j));
                    ++j;
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    protected TableViewer getViewer() {
        return this.viewer;
    }

    protected org.netxms.client.Table getResultSet() {
        return this.resultSet;
    }

    protected int getColumnIndex(String columnName) {
        if (this.resultSet == null) {
            return -1;
        }
        return this.resultSet.getColumnIndex(columnName);
    }
}

