/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCException;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.NodeComponentViewerTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfacesTabFilter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class InterfacesTab
extends NodeComponentViewerTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ALIAS = 2;
    public static final int COLUMN_INDEX = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final int COLUMN_IP_ADDRESS = 5;
    public static final int COLUMN_MAC_ADDRESS = 6;
    public static final int COLUMN_NIC_VENDOR = 7;
    public static final int COLUMN_VLAN = 8;
    public static final int COLUMN_MTU = 9;
    public static final int COLUMN_SPEED = 10;
    public static final int COLUMN_TYPE = 11;
    public static final int COLUMN_PHYSICAL_LOCATION = 12;
    public static final int COLUMN_ADMIN_STATE = 13;
    public static final int COLUMN_OPER_STATE = 14;
    public static final int COLUMN_EXPECTED_STATE = 15;
    public static final int COLUMN_STP_STATE = 16;
    public static final int COLUMN_STATUS = 17;
    public static final int COLUMN_OSPF_AREA = 18;
    public static final int COLUMN_OSPF_TYPE = 19;
    public static final int COLUMN_OSPF_STATE = 20;
    public static final int COLUMN_8021X_PAE_STATE = 21;
    public static final int COLUMN_8021X_BACKEND_STATE = 22;
    public static final int COLUMN_PEER_NODE = 23;
    public static final int COLUMN_PEER_INTERFACE = 24;
    public static final int COLUMN_PEER_MAC_ADDRESS = 25;
    public static final int COLUMN_PEER_NIC_VENDOR = 26;
    public static final int COLUMN_PEER_IP_ADDRESS = 27;
    public static final int COLUMN_PEER_PROTOCOL = 28;
    private InterfaceListLabelProvider labelProvider;
    private Action actionCopyMacAddressToClipboard;
    private Action actionCopyIpAddressToClipboard;
    private Action actionCopyPeerNameToClipboard;
    private Action actionCopyPeerMacToClipboard;
    private Action actionCopyPeerIpToClipboard;
    private boolean hideSubInterfaces = false;

    @Override
    protected void createTabContent(Composite parent) {
        super.createTabContent(parent);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.hideSubInterfaces = InterfacesTab.safeCast(settings.get("InterfacesTab.hideSubInterfaces"), settings.getBoolean("InterfacesTab.hideSubInterfaces"), this.hideSubInterfaces);
        this.filterText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("InterfacesTab.hideSubInterfaces", InterfacesTab.this.hideSubInterfaces);
            }
        });
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.hideSubInterfaces");
        State state = command.getState("org.netxms.ui.eclipse.objectview.commands.hideSubInterfaces.state");
        state.setValue((Object)this.hideSubInterfaces);
        service.refreshElements(command.getId(), null);
    }

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionCopyMacAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyMAC){

            public void run() {
                InterfacesTab.this.copyMacAddress(false);
            }
        };
        Messages.get();
        this.actionCopyIpAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(5);
            }
        };
        Messages.get();
        this.actionCopyPeerNameToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerName){

            public void run() {
                InterfacesTab.this.copyToClipboard(23);
            }
        };
        Messages.get();
        this.actionCopyPeerMacToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerMAC){

            public void run() {
                InterfacesTab.this.copyMacAddress(true);
            }
        };
        Messages.get();
        this.actionCopyPeerIpToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(27);
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyMacAddressToClipboard);
        manager.add((IAction)this.actionCopyIpAddressToClipboard);
        manager.add((IAction)this.actionCopyPeerNameToClipboard);
        manager.add((IAction)this.actionCopyPeerMacToClipboard);
        manager.add((IAction)this.actionCopyPeerIpToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this.viewer);
    }

    private void copyMacAddress(boolean peerMacAddress) {
        List selection = this.viewer.getStructuredSelection().toList();
        if (selection.size() > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.size()) {
                if (i > 0) {
                    sb.append(newLine);
                }
                MacAddress addr = null;
                addr = peerMacAddress ? this.labelProvider.getPeerMacAddress((Interface)selection.get(i)) : ((Interface)selection.get(i)).getMacAddress();
                sb.append(addr != null ? addr.toString() : "");
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChildren(3).toArray());
            this.viewer.packColumns();
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    public void hideSubInterfaces(boolean hide) {
        this.hideSubInterfaces = hide;
        ((InterfacesTabFilter)this.filter).setHideSubInterfaces(hide);
        this.viewer.refresh();
    }

    @Override
    protected void createViewer() {
        String[] stringArray = new String[29];
        Messages.get();
        stringArray[0] = Messages.InterfacesTab_ColId;
        Messages.get();
        stringArray[1] = Messages.InterfacesTab_ColName;
        Messages.get();
        stringArray[2] = Messages.InterfacesTab_Alias;
        Messages.get();
        stringArray[3] = Messages.InterfacesTab_ColIfIndex;
        Messages.get();
        stringArray[4] = Messages.InterfacesTab_ColDescription;
        Messages.get();
        stringArray[5] = Messages.InterfacesTab_ColIpAddr;
        Messages.get();
        stringArray[6] = Messages.InterfacesTab_ColMacAddr;
        stringArray[7] = "NIC vendor";
        stringArray[8] = "VLAN";
        Messages.get();
        stringArray[9] = Messages.InterfacesTab_MTU;
        Messages.get();
        stringArray[10] = Messages.InterfacesTab_Speed;
        Messages.get();
        stringArray[11] = Messages.InterfacesTab_ColIfType;
        stringArray[12] = "Location";
        Messages.get();
        stringArray[13] = Messages.InterfacesTab_ColAdminState;
        Messages.get();
        stringArray[14] = Messages.InterfacesTab_ColOperState;
        Messages.get();
        stringArray[15] = Messages.InterfacesTab_ColExpState;
        stringArray[16] = "STP state";
        Messages.get();
        stringArray[17] = Messages.InterfacesTab_ColStatus;
        stringArray[18] = "OSPF area";
        stringArray[19] = "OSPF type";
        stringArray[20] = "OSPF state";
        Messages.get();
        stringArray[21] = Messages.InterfacesTab_Col8021xPAE;
        Messages.get();
        stringArray[22] = Messages.InterfacesTab_Col8021xBackend;
        Messages.get();
        stringArray[23] = Messages.InterfacesTab_ColPeerNode;
        stringArray[24] = "Peer interface";
        Messages.get();
        stringArray[25] = Messages.InterfacesTab_ColPeerMAC;
        stringArray[26] = "Peer NIC vendor";
        Messages.get();
        stringArray[27] = Messages.InterfacesTab_ColPeerIP;
        Messages.get();
        stringArray[28] = Messages.InterfacesTab_PeerDiscoveryProtocol;
        String[] names = stringArray;
        int[] widths = new int[]{60, 150, 150, 70, 150, 100, 70, 90, 150, 100, 90, 200, 80, 80, 80, 80, 150, 150, 100, 120, 90, 80, 80, 80, 80, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider((TableViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new InterfacesTabFilter();
        ((InterfacesTabFilter)this.filter).setHideSubInterfaces(this.hideSubInterfaces);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable.V8");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)InterfacesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable.V8");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText, 0, 1024);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.labelProvider.setNode((AbstractNode)object);
        super.objectChanged(object);
    }

    @Override
    public String getFilterSettingName() {
        return "InterfacesTab.showFilter";
    }

    @Override
    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface;
    }

    @Override
    protected void syncAdditionalObjects(AbstractObject object) throws IOException, NXCException {
        ArrayList<Long> additionalSyncInterfaces = new ArrayList<Long>();
        for (AbstractObject obj : object.getAllChildren(3)) {
            long id = ((Interface)obj).getPeerInterfaceId();
            if (id == 0L) continue;
            additionalSyncInterfaces.add(id);
        }
        if (!additionalSyncInterfaces.isEmpty()) {
            this.session.syncMissingObjects(additionalSyncInterfaces, true, 2);
        }
    }
}

