/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractTraceWidget
extends Composite {
    private static final I18n i18n = LocalizationHelper.getI18n(AbstractTraceWidget.class);
    private static final int MAX_ELEMENTS = 500;
    protected View view;
    protected TableViewer viewer;
    protected AbstractTraceViewFilter filter = null;
    private LinkedList<Object> data = new LinkedList();
    private boolean paused = false;
    private long lastUpdated = 0L;
    private boolean updateScheduled = false;
    private Action actionPause;
    private Action actionCopy;

    public AbstractTraceWidget(Composite parent, int style, View view) {
        super(parent, style);
        this.view = view;
        this.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer((Composite)this, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setupViewer(this.viewer);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (String)this.getConfigPrefix());
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filter = this.createFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.createActions();
        this.createPopupMenu();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createActions() {
        this.actionPause = new /* Unavailable Anonymous Inner Class!! */;
        this.actionPause.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/pause.png"));
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IContributionItem)new Separator());
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    protected abstract void setupViewer(TableViewer var1);

    protected abstract AbstractTraceViewFilter createFilter();

    protected void addColumn(String name, int width) {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(name);
        tc.setWidth(width);
    }

    protected void addElement(Object element) {
        if (this.data.size() == 500) {
            this.data.removeLast();
        }
        this.data.addFirst(element);
        if (!this.paused) {
            long now = System.currentTimeMillis();
            if (now - this.lastUpdated > 200L) {
                this.viewer.setInput((Object)this.data.toArray());
                this.lastUpdated = now;
            } else if (!this.updateScheduled) {
                this.updateScheduled = true;
                this.getDisplay().timerExec(200, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public void clear() {
        this.data.clear();
        this.viewer.setInput((Object)new Object[0]);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected boolean isPaused() {
        return this.paused;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
        if (!paused) {
            this.viewer.setInput((Object)this.data.toArray());
        }
    }

    protected abstract String getConfigPrefix();

    protected void saveConfig() {
    }

    protected void setFilter(AbstractTraceViewFilter filter) {
        if (this.filter != null) {
            this.viewer.removeFilter((ViewerFilter)this.filter);
        }
        this.filter = filter;
        this.viewer.addFilter((ViewerFilter)filter);
    }

    public AbstractTraceViewFilter getFilter() {
        return this.filter;
    }

    public void setRootObject(long objectId) {
        this.filter.setRootObject(objectId);
        this.viewer.refresh();
    }

    protected void runInUIThread(Runnable runnable) {
        this.getDisplay().asyncExec(runnable);
    }

    private void copySelectionToClipboard() {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            StringBuilder sb = new StringBuilder();
            String newLine = WidgetHelper.getNewLineCharacters();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(0));
                for (int j = 1; j < this.viewer.getTable().getColumnCount(); ++j) {
                    sb.append('\t');
                    sb.append(selection[i].getText(j));
                }
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public Action getActionPause() {
        return this.actionPause;
    }

    public Action getActionCopy() {
        return this.actionCopy;
    }

    protected View getView() {
        return this.view;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }
}

