/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class LinkObjectToAssetAction
extends ObjectAction<AbstractObject> {
    private static final I18n i18n = LocalizationHelper.getI18n(LinkObjectToAssetAction.class);

    public LinkObjectToAssetAction(ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(AbstractObject.class, i18n.tr("&Link to asset..."), viewPlacement, selectionProvider);
        this.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/link-objects.png"));
    }

    protected void run(List<AbstractObject> objects) {
        ObjectSelectionDialog dlg;
        NXCSession session = Registry.getSession();
        if (objects.get(0).getAssetId() != 0L) {
            String question = String.format(i18n.tr("Object \"%s\" already linked to asset \"%s\". Are you sure you want to link it another asset?"), objects.get(0).getObjectName(), session.getObjectName(objects.get(0).getAssetId()));
            if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)i18n.tr("Confirm Link"), (String)question)) {
                return;
            }
        }
        if ((dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createAssetSelectionFilter())).open() != 0) {
            return;
        }
        AbstractObject asset = (AbstractObject)dlg.getSelectedObjects().get(0);
        if (!(asset instanceof Asset)) {
            return;
        }
        AbstractObject object = objects.get(0);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && (selection.getFirstElement() instanceof Rack || selection.getFirstElement() instanceof DataCollectionTarget) && !(selection.getFirstElement() instanceof Cluster);
    }

    static /* synthetic */ MessageAreaHolder access$000(LinkObjectToAssetAction x0) {
        return x0.getMessageArea();
    }
}

