/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Asset;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class UnlinkAssetFromObjectAction
extends ObjectAction<Asset> {
    private static final I18n i18n = LocalizationHelper.getI18n(UnlinkAssetFromObjectAction.class);

    public UnlinkAssetFromObjectAction(ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(Asset.class, i18n.tr("&Unlink"), viewPlacement, selectionProvider);
        this.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/disconnect.png"));
    }

    protected void run(List<Asset> objects) {
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)i18n.tr("Unlink Asset"), (String)(objects.size() == 1 ? i18n.tr("Asset \"{0}\" will be unlinked. Are you sure?", (Object)objects.get(0).getObjectName()) : i18n.tr("{0} assets will be uninked. Are you sure?", (Object)Integer.toString(objects.size()))))) {
            return;
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        int linkedAssets = 0;
        for (Object e : selection.toList()) {
            if (!(e instanceof Asset)) {
                return false;
            }
            if (((Asset)e).getLinkedObjectId() == 0L) continue;
            ++linkedAssets;
        }
        return linkedAssets > 0;
    }

    static /* synthetic */ MessageAreaHolder access$000(UnlinkAssetFromObjectAction x0) {
        return x0.getMessageArea();
    }
}

