/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AssetAttributeListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    static final I18n i18n = LocalizationHelper.getI18n(AssetAttributeListLabelProvider.class);
    public static final String[] DATA_TYPES = new String[]{i18n.tr("String"), i18n.tr("Integer"), i18n.tr("Number"), i18n.tr("Boolean"), i18n.tr("Enum"), i18n.tr("MAC address"), i18n.tr("IP address"), i18n.tr("UUID"), i18n.tr("Object reference"), i18n.tr("Date")};
    public static final String[] SYSTEM_TYPE = new String[]{i18n.tr("None"), i18n.tr("Serial"), i18n.tr("IP address"), i18n.tr("MAC address"), i18n.tr("Vendor"), i18n.tr("Model")};

    public String getColumnText(Object element, int columnIndex) {
        AssetAttribute attr = (AssetAttribute)element;
        switch (columnIndex) {
            case 2: {
                return DATA_TYPES[attr.getDataType().getValue()];
            }
            case 1: {
                return attr.getDisplayName();
            }
            case 6: {
                return attr.getAutofillScript().isEmpty() ? i18n.tr("No") : i18n.tr("Yes");
            }
            case 5: {
                return attr.isHidden() ? i18n.tr("Yes") : i18n.tr("No");
            }
            case 3: {
                return attr.isMandatory() ? i18n.tr("Yes") : i18n.tr("No");
            }
            case 4: {
                return attr.isUnique() ? i18n.tr("Yes") : i18n.tr("No");
            }
            case 0: {
                return attr.getName();
            }
            case 8: {
                return Integer.toString(attr.getRangeMax());
            }
            case 7: {
                return Integer.toString(attr.getRangeMin());
            }
            case 9: {
                return SYSTEM_TYPE[attr.getSystemType().getValue()];
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }
}

