/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class NetworkMapConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=false)
    private int zoomLevel = 100;
    @Element(required=false)
    private boolean objectDoubleClickEnabled = false;

    public static NetworkMapConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (NetworkMapConfig)serializer.read(NetworkMapConfig.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public boolean isObjectDoubleClickEnabled() {
        return this.objectDoubleClickEnabled;
    }

    public void setObjectDoubleClickEnabled(boolean objectDoubleClickEnabled) {
        this.objectDoubleClickEnabled = objectDoubleClickEnabled;
    }
}

