/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.modules.charts.api.ChartColor;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.api.GaugeColorMode;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.GaugeConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.ComparisonChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.tools.WidgetHelper;

public class GaugeElement
extends ComparisonChartElement {
    private GaugeConfig elementConfig;
    private Font heightCalculationFont = null;

    public GaugeElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.elementConfig = GaugeConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elementConfig = new GaugeConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.elementConfig);
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLabelsVisible(this.elementConfig.isShowLegend());
        chartConfig.setLabelsInside(this.elementConfig.isLegendInside());
        chartConfig.setTransposed(this.elementConfig.isVertical());
        chartConfig.setElementBordersVisible(this.elementConfig.isElementBordersVisible());
        chartConfig.setMinYScaleValue(this.elementConfig.getMinValue());
        chartConfig.setMaxYScaleValue(this.elementConfig.getMaxValue());
        chartConfig.setLeftYellowZone(this.elementConfig.getLeftYellowZone());
        chartConfig.setLeftRedZone(this.elementConfig.getLeftRedZone());
        chartConfig.setRightYellowZone(this.elementConfig.getRightYellowZone());
        chartConfig.setRightRedZone(this.elementConfig.getRightRedZone());
        chartConfig.setFontName(this.elementConfig.getFontName());
        chartConfig.setFontSize(this.elementConfig.getFontSize());
        chartConfig.setExpectedTextWidth(this.elementConfig.getExpectedTextWidth());
        chartConfig.setGaugeColorMode(this.elementConfig.getColorMode());
        this.updateThresholds = this.elementConfig.getColorMode() == GaugeColorMode.THRESHOLD.getValue();
        switch (this.elementConfig.getGaugeType()) {
            case 1: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.BAR_GAUGE, chartConfig);
                break;
            }
            case 3: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.CIRCULAR_GAUGE, chartConfig);
                break;
            }
            case 2: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.TEXT_GAUGE, chartConfig);
                break;
            }
            default: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.DIAL_GAUGE, chartConfig);
            }
        }
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        this.chart.setPaletteEntry(0, new ChartColor(this.elementConfig.getCustomColor()));
        this.configureMetrics();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected ChartDciConfig[] getDciList() {
        return this.elementConfig.getDciList();
    }

    protected int getPreferredHeight() {
        if (this.elementConfig.getGaugeType() == 1) {
            return this.elementConfig.isVertical() ? 40 * this.elementConfig.getDciList().length : 40;
        }
        if (this.elementConfig.getGaugeType() == 2) {
            if (this.heightCalculationFont == null) {
                int fontSize = this.elementConfig.getFontSize();
                if (fontSize == 0) {
                    fontSize = 24;
                }
                this.heightCalculationFont = new Font((Device)this.getDisplay(), this.elementConfig.getFontName(), fontSize, 1);
            }
            int h = WidgetHelper.getTextExtent((Control)this, (Font)this.heightCalculationFont, (String)"X").y + 10;
            if (this.elementConfig.isShowLegend()) {
                h += WidgetHelper.getTextExtent((Control)this, (String)"X").y;
            }
            return this.elementConfig.isVertical() ? h * this.elementConfig.getDciList().length : h;
        }
        return super.getPreferredHeight();
    }
}

