/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.mt.MappingTableDescriptor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.dialogs.MappingTableCreationDialog;
import org.netxms.nxmc.modules.nxsl.views.MappingTableEditorView;
import org.netxms.nxmc.modules.nxsl.views.helpers.MappingTableListComparator;
import org.netxms.nxmc.modules.nxsl.views.helpers.MappingTableListFilter;
import org.netxms.nxmc.modules.nxsl.views.helpers.MappingTableListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MappingTableManagerView
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(MappingTableManagerView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_FLAGS = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private NXCSession session;
    private SessionListener listener;
    private Map<Integer, MappingTableDescriptor> mappingTables = new HashMap();
    private SortableTableViewer viewer;
    private Action actionNewTable;
    private Action actionEditTable;
    private Action actionDeleteTables;

    public MappingTableManagerView() {
        super(i18n.tr("Mapping Tables"), ResourceManager.getImageDescriptor((String)"icons/config-views/mapping-tables.png"), "MappingTableManagerView", true);
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        int[] widths = new int[]{80, 160, 80, 400};
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Flags"), i18n.tr("Description")};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MappingTableListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new MappingTableListComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        MappingTableListFilter filter = new MappingTableListFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"MappingTablesList");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionNewTable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNewTable);
        this.actionEditTable = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditTable.setEnabled(false);
        this.actionDeleteTables = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteTables.setEnabled(false);
        this.addKeyBinding("M1+D", (IAction)this.actionDeleteTables);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNewTable);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewTable);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewTable);
        mgr.add((IAction)this.actionEditTable);
        mgr.add((IAction)this.actionDeleteTables);
    }

    public void refresh() {
        this.refresh(0);
    }

    private void refresh(int tableId) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNewTable() {
        MappingTableCreationDialog dlg = new MappingTableCreationDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editTable() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        MappingTableDescriptor d = (MappingTableDescriptor)selection.getFirstElement();
        this.openView((View)new MappingTableEditorView(d.getId(), d.getName()));
    }

    private void deleteTables() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete"), (String)i18n.tr("Are you sure you want to delete selected mapping tables?"))) {
            return;
        }
        ArrayList<Integer> tables = new ArrayList<Integer>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof MappingTableDescriptor)) continue;
            tables.add(((MappingTableDescriptor)o).getId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

