/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Condition;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.xnap.commons.i18n.I18n;

public class ConditionScript
extends ObjectPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(ConditionScript.class);
    private Condition condition;
    private ScriptEditor filterSource;
    private String initialScript;

    public ConditionScript(AbstractObject object) {
        super(i18n.tr("Script"), object);
    }

    public String getId() {
        return "conditionEvents";
    }

    public int getPriority() {
        return 10;
    }

    public boolean isVisible() {
        return this.object instanceof Condition;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.condition = (Condition)this.object;
        this.initialScript = this.condition.getScript();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Status calculation script"));
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, false, "Variables:\r\n\t$values\tarray containing values for configured DCIs (in same order as DCIs are listed in configuration)\r\n\r\nReturn value: true/false to indicate if condition is active or not");
        this.filterSource.setText(this.condition.getScript());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.initialScript.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        String newScript = this.filterSource.getText();
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.condition.getObjectId());
        md.setScript(newScript);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

