/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.Route;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.RoutingTableComparator;
import org.netxms.nxmc.modules.objects.views.helpers.RoutingTableLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class RoutingTableView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(RoutingTableView.class);
    public static final int COLUMN_DESTINATION = 0;
    public static final int COLUMN_NEXT_HOP = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_TYPE = 3;
    public static final int COLUMN_METRIC = 4;
    public static final int COLUMN_PROTOCOL = 5;
    private NXCSession session = Registry.getSession();
    private SortableTableViewer viewer;
    private boolean refreshPending = true;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionCopyRowToClipboard;

    public RoutingTableView() {
        super(i18n.tr("Routing Table"), ResourceManager.getImageDescriptor((String)"icons/object-views/routing_table.gif"), "RoutingTable", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && (((Node)context).hasAgent() || ((Node)context).hasSnmpAgent());
    }

    public int getPriority() {
        return 170;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("Destination"), i18n.tr("Next hop"), i18n.tr("Interface"), i18n.tr("Type"), i18n.tr("Metric"), i18n.tr("Protocol")};
        int[] widths = new int[]{180, 140, 200, 140, 140, 180};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RoutingTableLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RoutingTableComparator());
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionCopyRowToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRowToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        String objectName = this.session.getObjectName(this.getObjectId());
        this.clearMessages();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void activate() {
        super.activate();
        if (this.refreshPending) {
            this.refreshPending = false;
            this.refresh();
        }
    }

    protected void onObjectChange(AbstractObject object) {
        this.viewer.setInput((Object)new Route[0]);
        if (object != null) {
            if (this.isActive()) {
                this.refresh();
            } else {
                this.refreshPending = true;
            }
        }
    }
}

