/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ClusterResourceListComparator
extends ViewerComparator {
    private static I18n i18n = LocalizationHelper.getI18n(ClusterResourceListComparator.class);
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        ClusterResource r1 = (ClusterResource)e1;
        ClusterResource r2 = (ClusterResource)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 0: {
                result = r1.getName().compareToIgnoreCase(r2.getName());
                break;
            }
            case 1: {
                byte[] addr1 = r1.getVirtualAddress().getAddress();
                byte[] addr2 = r2.getVirtualAddress().getAddress();
                result = 0;
                for (int i = 0; i < addr1.length && result == 0; ++i) {
                    result = addr1[i] - addr2[i];
                }
                break;
            }
            case 2: {
                result = this.getOwnerName(r1).compareToIgnoreCase(this.getOwnerName(r2));
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getOwnerName(ClusterResource r) {
        long ownerId = r.getCurrentOwner();
        if (ownerId > 0L) {
            Node owner = (Node)this.session.findObjectById(ownerId, Node.class);
            return owner != null ? owner.getObjectName() : "<" + Long.toString(ownerId) + ">";
        }
        return i18n.tr("NONE");
    }
}

