/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;

public class RadioInterfaceComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        RadioInterface rif1 = (RadioInterface)e1;
        RadioInterface rif2 = (RadioInterface)e2;
        int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 1 -> rif1.getAccessPoint().getMacAddress().compareTo(rif2.getAccessPoint().getMacAddress());
            case 3 -> rif1.getAccessPoint().getModel().compareToIgnoreCase(rif2.getAccessPoint().getModel());
            case 0 -> rif1.getAccessPoint().getObjectName().compareToIgnoreCase(rif2.getAccessPoint().getObjectName());
            case 4 -> rif1.getAccessPoint().getSerialNumber().compareToIgnoreCase(rif2.getAccessPoint().getSerialNumber());
            case 2 -> rif1.getAccessPoint().getVendor().compareToIgnoreCase(rif2.getAccessPoint().getVendor());
            case 9 -> rif1.getChannel() - rif2.getChannel();
            case 5 -> rif1.getIndex() - rif2.getIndex();
            case 7 -> rif1.getMacAddress().compareTo(rif2.getMacAddress());
            case 8 -> this.getVendorByMAC(rif1.getMacAddress()).compareToIgnoreCase(this.getVendorByMAC(rif2.getMacAddress()));
            case 6 -> rif1.getName().compareToIgnoreCase(rif2.getName());
            case 10 -> rif1.getPowerDBm() - rif2.getPowerDBm();
            case 11 -> rif1.getPowerMW() - rif2.getPowerMW();
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendorByMAC(MacAddress macAddr) {
        String vendor = this.session.getVendorByMac(macAddr, null);
        return vendor != null ? vendor : "";
    }
}

