/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ComponentTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static I18n i18n = LocalizationHelper.getI18n(ComponentTreeLabelProvider.class);
    private static final String[] className = new String[]{null, i18n.tr("Other"), i18n.tr("Unknown"), i18n.tr("Chassis"), i18n.tr("Backplane"), i18n.tr("Container"), i18n.tr("Power Supply"), i18n.tr("Fan"), i18n.tr("Sensor"), i18n.tr("Module"), i18n.tr("Port"), i18n.tr("Stack")};
    private Map<Integer, Interface> interfaces = new HashMap();

    public void setNode(AbstractNode node) {
        this.interfaces.clear();
        if (node != null) {
            for (AbstractObject i : node.getAllChildren(3)) {
                if (((Interface)i).getIfIndex() <= 0) continue;
                this.interfaces.put(((Interface)i).getIfIndex(), (Interface)i);
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        PhysicalComponent c = (PhysicalComponent)element;
        switch (columnIndex) {
            case 1: {
                try {
                    return className[c.getPhyClass()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return className[2];
                }
            }
            case 2: {
                return c.getDescription();
            }
            case 7: {
                return this.getInterfaceName(c);
            }
            case 4: {
                return c.getFirmware();
            }
            case 3: {
                return c.getModel();
            }
            case 0: {
                return c.getDisplayName();
            }
            case 5: {
                return c.getSerialNumber();
            }
            case 6: {
                return c.getVendor();
            }
        }
        return null;
    }

    private String getInterfaceName(PhysicalComponent c) {
        int ifIndex = c.getIfIndex();
        if (ifIndex <= 0) {
            return "";
        }
        Interface iface = (Interface)this.interfaces.get(ifIndex);
        return iface != null ? iface.getObjectName() : null;
    }
}

