/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.tools.WidgetHelper;

public class SendNotificationDialog
extends Dialog {
    private String recipient;
    private String subject;
    private String message;
    private String channelName;
    private Combo channelNameCombo;
    private LabeledText recipientField;
    private LabeledText subjectField;
    private LabeledText messageField;
    private List<NotificationChannel> channels = null;

    public SendNotificationDialog(Shell parentShell, String channelName) {
        super(parentShell);
        PreferenceStore settings = PreferenceStore.getInstance();
        this.recipient = settings.getAsString("SendNotification.PhoneNumber", "");
        this.channelName = channelName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Send Notification");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.channelNameCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Channel name", (Object)gd);
        this.channelNameCombo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recipientField = new LabeledText(dialogArea, 0);
        this.recipientField.setLabel("Recipient");
        this.recipientField.setText(this.recipient);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.recipientField.setLayoutData((Object)gd);
        this.subjectField = new LabeledText(dialogArea, 0);
        this.subjectField.setLabel("Subject");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.subjectField.setLayoutData((Object)gd);
        this.messageField = new LabeledText(dialogArea, 0);
        this.messageField.setLabel("Message");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.messageField.setLayoutData((Object)gd);
        if (this.recipient != null && !this.recipient.isEmpty()) {
            this.messageField.getTextControl().setFocus();
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    private void updateChannelSelector() {
        this.channelNameCombo.removeAll();
        int selection = -1;
        for (int i = 0; i < this.channels.size(); ++i) {
            NotificationChannel nc = (NotificationChannel)this.channels.get(i);
            this.channelNameCombo.add(nc.getName());
            if (this.channelName == null || !this.channelName.equalsIgnoreCase(nc.getName())) continue;
            selection = i;
        }
        if (selection > 0) {
            this.channelNameCombo.select(selection);
            this.recipientField.setEnabled(((NotificationChannel)this.channels.get((int)this.channelNameCombo.getSelectionIndex())).getConfigurationTemplate().needRecipient);
            this.subjectField.setEnabled(((NotificationChannel)this.channels.get((int)this.channelNameCombo.getSelectionIndex())).getConfigurationTemplate().needSubject);
        }
    }

    protected void okPressed() {
        this.recipient = this.recipientField.getText().trim();
        this.subject = this.subjectField.getText();
        this.message = this.messageField.getText();
        this.channelName = this.channelNameCombo.getItem(this.channelNameCombo.getSelectionIndex());
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("SendNotification.PhoneNumber", this.recipient);
        super.okPressed();
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getChannelName() {
        return this.channelName;
    }
}

