/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciInfo;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Map<Long, DciInfo> dciNameCache = new HashMap<Long, DciInfo>();
    private List<SingleDciConfig> elementList;

    public DciListLabelProvider(List<SingleDciConfig> elementList) {
        this.elementList = elementList;
        this.session = ConsoleSharedData.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SingleDciConfig dci = (SingleDciConfig)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(dci.getNodeId());
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.getNodeId()) + "]";
            }
            case 2: {
                String string;
                String name = this.dciNameCache.get((Object)Long.valueOf((long)dci.dciId)).displayName;
                if (name != null) {
                    string = name;
                } else {
                    Messages.get();
                    string = Messages.DciListLabelProvider_Unresolved;
                }
                return string;
            }
            case 3: {
                return dci.name;
            }
        }
        return null;
    }

    public void resolveDciNames(final Collection<SingleDciConfig> dciList) {
        Messages.get();
        new ConsoleJob(Messages.DciListLabelProvider_JobName, null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map names = DciListLabelProvider.this.session.dciIdsToNames(dciList);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).DciListLabelProvider.this.dciNameCache = names;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DciListLabelProvider_JobError;
            }
        }.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String description) {
        this.dciNameCache.put(dciId, new DciInfo("", description));
    }
}

