/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objects.ObjectWrapper;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SummaryTableContentProvider
implements ITreeContentProvider {
    private Table table = null;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.table = newInput != null && newInput instanceof Table ? (Table)newInput : null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.table == null) {
            return new Object[0];
        }
        ArrayList<RowWrapper> list = new ArrayList<RowWrapper>();
        TableRow[] rows = this.table.getAllRows();
        int i = 0;
        while (i < rows.length) {
            if (rows[i].getBaseRow() == -1) {
                list.add(new RowWrapper(rows[i], i, null));
            } else {
                RowWrapper p = this.findParent(list, rows[i].getBaseRow());
                if (p != null) {
                    p.add(new RowWrapper(rows[i], i, p));
                }
            }
            ++i;
        }
        return list.toArray();
    }

    private RowWrapper findParent(List<RowWrapper> list, int id) {
        for (RowWrapper r : list) {
            if (r.id != id) continue;
            return r;
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        return ((RowWrapper)((Object)parentElement)).children.toArray();
    }

    public Object getParent(Object element) {
        return ((RowWrapper)((Object)element)).parent;
    }

    public boolean hasChildren(Object element) {
        return !((RowWrapper)((Object)element)).children.isEmpty();
    }

    public void dispose() {
    }

    private class RowWrapper
    extends TableRow
    implements ObjectWrapper {
        protected RowWrapper parent;
        protected int id;
        protected List<RowWrapper> children;

        protected RowWrapper(TableRow src, int id, RowWrapper parent) {
            super(src);
            this.children = new ArrayList<RowWrapper>(0);
            this.id = id;
            this.parent = parent;
        }

        protected void add(RowWrapper r) {
            this.children.add(r);
        }

        public AbstractObject getObject() {
            return (AbstractObject)ConsoleSharedData.getSession().findObjectById(this.getObjectId(), AbstractNode.class);
        }
    }
}

