/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.GeoLocationCache;

public class LoginListener
implements ConsoleLoginListener {
    public void afterLogin(NXCSession session, Display display) {
        GeoLocationCache.getInstance().initialize(session);
        Job housekeeper = new Job("Tile housekeeper"){

            protected IStatus run(IProgressMonitor monitor) {
                File targetDir;
                Location loc = Platform.getInstanceLocation();
                try {
                    targetDir = new File(loc.getURL().toURI());
                }
                catch (URISyntaxException e) {
                    targetDir = new File(loc.getURL().getPath());
                }
                File base = new File(targetDir, "OSM");
                if (base.isDirectory()) {
                    LoginListener.cleanTileFiles(base.listFiles());
                }
                this.schedule(3600000L);
                return Status.OK_STATUS;
            }
        };
        housekeeper.setUser(false);
        housekeeper.setSystem(true);
        housekeeper.schedule();
    }

    private static void cleanTileFiles(File[] files) {
        long now = System.currentTimeMillis();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                LoginListener.cleanTileFiles(f.listFiles());
            } else if (now - f.lastModified() > 604800000L) {
                Activator.log("Deleting expired tile file " + f.getAbsolutePath());
                f.delete();
            }
            ++n2;
        }
    }
}

