/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.propertypages;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportingJob;

public class Notifications
extends PropertyPage {
    public static final String ID = "org.netxms.ui.eclipse.reporter.propertypages.Notification";
    private Composite emailGroup;
    private ListViewer listViewer;
    private Button sendReport;
    private Button sendNotify;
    private Button pdfFormat;
    private Button xlsxFormat;
    private ReportingJob job = null;

    protected Control createContents(Composite parent) {
        this.job = (ReportingJob)this.getElement().getAdapter(ReportingJob.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        this.sendNotify = new Button(dialogArea, 32);
        this.sendNotify.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.sendNotify.setText("Send notification on job completion");
        this.sendNotify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Notifications.this.job.setNotifyOnCompletion(Notifications.this.sendNotify.getSelection());
                Notifications.this.recursiveSetEnabled((Control)Notifications.this.emailGroup, Notifications.this.sendNotify.getSelection());
                Notifications.this.xlsxFormat.setEnabled(Notifications.this.sendReport.isEnabled() && Notifications.this.sendReport.getSelection());
                Notifications.this.pdfFormat.setEnabled(Notifications.this.sendReport.isEnabled() && Notifications.this.sendReport.getSelection());
                Notifications.this.emailGroup.layout(true, true);
            }
        });
        this.emailGroup = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.emailGroup.setLayout((Layout)layout);
        this.emailGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblMail = new Label(this.emailGroup, 0);
        lblMail.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        lblMail.setText("Recipients");
        this.listViewer = new ListViewer(this.emailGroup, 2562);
        this.listViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).compareToIgnoreCase((String)e2);
            }
        });
        Button buttonAdd = new Button(this.emailGroup, 8);
        GridData gd = new GridData(4, 128, false, false);
        gd.widthHint = 90;
        buttonAdd.setLayoutData((Object)gd);
        buttonAdd.setText("Add...");
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Notifications.this.addMail();
            }
        });
        Button buttonRemove = new Button(this.emailGroup, 8);
        gd = new GridData(4, 128, false, false);
        gd.widthHint = 90;
        buttonRemove.setLayoutData((Object)gd);
        buttonRemove.setText("Remove");
        buttonRemove.setEnabled(false);
        buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Notifications.this.removeMail();
            }
        });
        Composite attachmentGroup = new Composite(this.emailGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        attachmentGroup.setLayout((Layout)layout);
        attachmentGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this.sendReport = new Button(attachmentGroup, 32);
        this.sendReport.setLayoutData((Object)new GridData(16384, 4, true, false, 2, 1));
        this.sendReport.setText("Attach rendered report to notification email as");
        this.sendReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Notifications.this.xlsxFormat.setEnabled(Notifications.this.sendReport.getSelection());
                Notifications.this.pdfFormat.setEnabled(Notifications.this.sendReport.getSelection());
            }
        });
        this.pdfFormat = new Button(attachmentGroup, 16);
        this.pdfFormat.setEnabled(this.sendReport.getSelection());
        this.pdfFormat.setText("PDF");
        this.pdfFormat.setSelection(true);
        this.xlsxFormat = new Button(attachmentGroup, 16);
        this.xlsxFormat.setEnabled(this.sendReport.getSelection());
        this.xlsxFormat.setText("XLSX");
        this.recursiveSetEnabled((Control)this.emailGroup, false);
        return dialogArea;
    }

    private void addMail() {
        InputDialog dlg = new InputDialog(this.emailGroup.getShell(), "Add mail", "Enter mail", "", new IInputValidator(){
            private static final String VALIDATOR_REGEXP = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";

            public String isValid(String newText) {
                if (!newText.matches(VALIDATOR_REGEXP)) {
                    return "Invalid email address";
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            this.job.getEmailRecipients().add(dlg.getValue());
            this.listViewer.setInput((Object)this.job.getEmailRecipients().toArray());
        }
    }

    private void removeMail() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        for (Object o : selection.toList()) {
            this.job.getEmailRecipients().remove((String)o);
        }
        this.listViewer.setInput((Object)this.job.getEmailRecipients().toArray());
    }

    public void recursiveSetEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Composite comp = (Composite)control;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }

    public boolean performOk() {
        if (this.sendReport.getSelection()) {
            this.job.setRenderFormat(this.pdfFormat.getSelection() ? ReportRenderFormat.PDF : ReportRenderFormat.XLSX);
        } else {
            this.job.setRenderFormat(ReportRenderFormat.NONE);
        }
        return true;
    }
}

