/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class MultiSelectFieldEditor
extends FieldEditor {
    private List<Value> values = new ArrayList<Value>();
    private ValueSelector valueSelector;

    public MultiSelectFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
        if (parameter.getMultiselectValues() != null && !parameter.getMultiselectValues().isEmpty()) {
            String[] parts;
            String[] stringArray = parts = parameter.getMultiselectValues().split(";");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                this.values.add(new Value(p.trim()));
                ++n2;
            }
            this.valueSelector.updateSelectionText();
        }
    }

    @Override
    protected Control createContent(Composite parent) {
        this.valueSelector = new ValueSelector(parent);
        return this.valueSelector;
    }

    @Override
    public String getValue() {
        StringBuilder sb = new StringBuilder();
        for (Value v : this.values) {
            if (!v.selected) continue;
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(v.value);
        }
        return sb.toString();
    }

    private static class Value {
        String displayName;
        String value;
        boolean selected;

        Value(String input) {
            String[] parts = input.split("=");
            if (parts.length > 1) {
                this.displayName = parts[0].trim();
                this.value = parts[1].trim();
            } else {
                this.displayName = this.value = input;
            }
            if (this.displayName.endsWith("[x]")) {
                this.displayName = this.displayName.substring(0, this.displayName.length() - 3).trim();
                this.selected = true;
            } else {
                this.selected = false;
            }
        }
    }

    private class ValueSelectionDialog
    extends Dialog {
        private Button[] selectors;

        protected ValueSelectionDialog(Shell parentShell) {
            super(parentShell);
            this.selectors = new Button[MultiSelectFieldEditor.this.values.size()];
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(MultiSelectFieldEditor.this.parameter.getDescription());
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            dialogArea.setLayout((Layout)layout);
            int i = 0;
            while (i < MultiSelectFieldEditor.this.values.size()) {
                Value v = MultiSelectFieldEditor.this.values.get(i);
                this.selectors[i] = new Button(dialogArea, 32);
                this.selectors[i].setText(v.displayName);
                this.selectors[i].setSelection(v.selected);
                ++i;
            }
            return dialogArea;
        }

        protected void okPressed() {
            int i = 0;
            while (i < this.selectors.length) {
                MultiSelectFieldEditor.this.values.get((int)i).selected = this.selectors[i].getSelection();
                ++i;
            }
            super.okPressed();
        }
    }

    private class ValueSelector
    extends AbstractSelector {
        public ValueSelector(Composite parent) {
            super(parent, 0, 2);
        }

        protected void selectionButtonHandler() {
            ValueSelectionDialog dlg = new ValueSelectionDialog(this.getShell());
            if (dlg.open() == 0) {
                this.updateSelectionText();
            }
        }

        public void updateSelectionText() {
            StringBuilder sb = new StringBuilder();
            for (Value v : MultiSelectFieldEditor.this.values) {
                if (!v.selected) continue;
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(v.displayName);
            }
            this.setText(sb.toString());
        }
    }
}

