/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.SortingColumnSelectionDialog;
import org.netxms.ui.eclipse.dashboard.propertypages.helpers.SortColumnTableLabelProvider;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DciSummaryTableConfig;
import org.netxms.ui.eclipse.datacollection.widgets.SummaryTableSelector;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DciSummaryTable
extends PropertyPage {
    public static final int NAME = 0;
    public static final int ORDER = 1;
    private DciSummaryTableConfig config;
    private List<String> currSortingList;
    private TitleConfigurator title;
    private ObjectSelector objectSelector;
    private SummaryTableSelector tableSelector;
    private Spinner refreshInterval;
    private Spinner numRowsShow;
    private SortableTableViewer sortTables;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private Button buttonUp;
    private Button buttonDown;

    protected Control createContents(Composite parent) {
        this.config = (DciSummaryTableConfig)this.getElement().getAdapter(DciSummaryTableConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        this.currSortingList = this.config.getSortingColumnList();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.DciSummaryTable_BaseObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getBaseObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.tableSelector = new SummaryTableSelector(dialogArea, 0, 8);
        Messages.get();
        this.tableSelector.setLabel(Messages.DciSummaryTable_SummaryTable);
        this.tableSelector.setTableId(this.config.getTableId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.tableSelector.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.refreshInterval = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.DciSummaryTable_RefreshInterval, (int)0, (int)10000, (Object)gd);
        this.refreshInterval.setSelection(this.config.getRefreshInterval());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.numRowsShow = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"Display limit (0 for unlimited)", (int)0, (int)10000, (Object)gd);
        this.numRowsShow.setSelection(this.config.getNumRowShown());
        Label label = new Label(dialogArea, 0);
        label.setText("Ordering");
        String[] columnNames = new String[]{"Column", "Direction"};
        int[] columnWidths = new int[]{300, 100};
        this.sortTables = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 0, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.sortTables.getTable().setLayoutData((Object)gd);
        this.sortTables.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sortTables.setLabelProvider((IBaseLabelProvider)new SortColumnTableLabelProvider());
        this.sortTables.setInput(this.currSortingList);
        this.sortTables.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int index = DciSummaryTable.this.currSortingList.indexOf(selection.getFirstElement());
                DciSummaryTable.this.buttonUp.setEnabled(selection.size() == 1 && index > 0);
                DciSummaryTable.this.buttonDown.setEnabled(selection.size() == 1 && index >= 0 && index < DciSummaryTable.this.currSortingList.size() - 1);
                DciSummaryTable.this.buttonEdit.setEnabled(selection.size() == 1);
                DciSummaryTable.this.buttonRemove.setEnabled(selection.size() > 0);
            }
        });
        this.sortTables.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DciSummaryTable.this.buttonEdit.notifyListeners(13, new Event());
            }
        });
        Composite buttons = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 45;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        Composite leftButtons = new Composite(buttons, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginBottom = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        leftButtons.setLayoutData((Object)gd);
        this.buttonUp = new Button(leftButtons, 8);
        this.buttonUp.setText("UP");
        this.buttonUp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.moveUp();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonUp.setLayoutData((Object)rd);
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(leftButtons, 8);
        this.buttonDown.setText("Down");
        this.buttonDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.moveDown();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonDown.setLayoutData((Object)rd);
        this.buttonDown.setEnabled(false);
        Composite rightButtons = new Composite(buttons, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginBottom = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = true;
        rightButtons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(rightButtons, 8);
        this.buttonAdd.setText("Add");
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.add();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(rightButtons, 8);
        this.buttonEdit.setText("Edit");
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.edit();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(rightButtons, 8);
        this.buttonRemove.setText("Delete");
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DciSummaryTable.this.remove();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        return dialogArea;
    }

    private void moveUp() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        int index = this.currSortingList.indexOf(element);
        if (index <= 0) {
            return;
        }
        String a = this.currSortingList.get(index - 1);
        this.currSortingList.set(index - 1, this.currSortingList.get(index));
        this.currSortingList.set(index, a);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
        this.sortTables.setSelection((ISelection)selection);
    }

    private void moveDown() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        int index = this.currSortingList.indexOf(element);
        if (index >= this.currSortingList.size() - 1 && index < 0) {
            return;
        }
        String a = this.currSortingList.get(index + 1);
        this.currSortingList.set(index + 1, this.currSortingList.get(index));
        this.currSortingList.set(index, a);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
        this.sortTables.setSelection((ISelection)selection);
    }

    private void add() {
        String s;
        SortingColumnSelectionDialog dlg = new SortingColumnSelectionDialog(this.getShell(), null, false, this.tableSelector.getTableId());
        if (dlg.open() == 0 && !this.currSortingList.contains(s = dlg.getColumnName())) {
            this.currSortingList.add(s);
            this.sortTables.setInput((Object)this.currSortingList.toArray());
        }
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        SortingColumnSelectionDialog dlg = new SortingColumnSelectionDialog(this.getShell(), element.substring(1), element.charAt(0) == '>', this.tableSelector.getTableId());
        if (dlg.open() == 0) {
            String s = dlg.getColumnName();
            int index = this.currSortingList.indexOf(element);
            if (index < this.currSortingList.size() && index >= 0) {
                this.currSortingList.set(index, s);
                this.sortTables.setInput((Object)this.currSortingList.toArray());
            }
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.sortTables.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String element = (String)selection.getFirstElement();
        this.currSortingList.remove(element);
        this.sortTables.setInput((Object)this.currSortingList.toArray());
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setBaseObjectId(this.objectSelector.getObjectId());
        this.config.setTableId(this.tableSelector.getTableId());
        this.config.setRefreshInterval(this.refreshInterval.getSelection());
        this.config.setNumRowShown(this.numRowsShow.getSelection());
        this.config.setSortingColumnList(this.currSortingList);
        return true;
    }
}

