/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.console.api.ColorProvider;

public class ColorManager {
    private static ColorManager instance = null;
    private Map<Integer, ColorProvider> providers = new TreeMap<Integer, ColorProvider>();

    public static ColorManager getInstance() {
        return instance;
    }

    protected static void create() {
        if (instance == null) {
            instance = new ColorManager();
        }
    }

    private ColorManager() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.colorproviders");
        int i = 0;
        while (i < elements.length) {
            try {
                ColorProvider p = (ColorProvider)elements[i].createExecutableExtension("class");
                int priority = 65535;
                String value = elements[i].getAttribute("priority");
                if (value != null) {
                    try {
                        priority = Integer.parseInt(value);
                        if (priority < 0) {
                            priority = 65535;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.providers.put(priority, p);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public RGB getColor(String name) {
        for (ColorProvider p : this.providers.values()) {
            RGB rgb = p.getColor(name);
            if (rgb == null) continue;
            return rgb;
        }
        return null;
    }
}

