/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DCIAutoBind
extends PropertyPage {
    private BaseBusinessService businessService;
    private Button checkboxEnableBind;
    private Button checkboxEnableUnbind;
    private Combo thresholdCombo;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialAutoBindFilter;
    private int initialStatusThreshold;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.businessService = (BaseBusinessService)this.getElement().getAdapter(BaseBusinessService.class);
        this.initialBind = this.businessService.isAutoBindEnabled();
        this.initialUnbind = this.businessService.isAutoUnbindEnabled();
        this.initialAutoBindFilter = this.businessService.getAutoBindFilter();
        this.initialAutoBindFilter = this.businessService.getAutoBindFilter();
        this.initialStatusThreshold = this.businessService.getObjectStatusThreshold();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableBind = new Button(dialogArea, 32);
        this.checkboxEnableBind.setText("Automatically add DCI selected by filter to this business service as check");
        this.checkboxEnableBind.setSelection(this.businessService.isDciAutoBindEnabled());
        this.checkboxEnableBind.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (DCIAutoBind.this.checkboxEnableBind.getSelection()) {
                    DCIAutoBind.this.filterSource.setEnabled(true);
                    DCIAutoBind.this.filterSource.setFocus();
                    DCIAutoBind.this.checkboxEnableUnbind.setEnabled(true);
                    DCIAutoBind.this.thresholdCombo.setEnabled(true);
                } else {
                    DCIAutoBind.this.filterSource.setEnabled(false);
                    DCIAutoBind.this.checkboxEnableUnbind.setEnabled(false);
                    DCIAutoBind.this.thresholdCombo.setEnabled(false);
                }
            }
        });
        this.checkboxEnableUnbind = new Button(dialogArea, 32);
        this.checkboxEnableUnbind.setText("Automatically remove DCI selected by filter from this business service");
        this.checkboxEnableUnbind.setSelection(this.businessService.isDciAutoUnbindEnabled());
        this.checkboxEnableUnbind.setEnabled(this.businessService.isDciAutoBindEnabled());
        this.thresholdCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Status Threashold", (Object)new GridData());
        this.thresholdCombo.add("Default");
        int i = 1;
        while (i <= 4) {
            this.thresholdCombo.add(StatusDisplayInfo.getStatusText((int)i));
            ++i;
        }
        this.thresholdCombo.select(this.businessService.getDciStatusThreshold());
        Label label = new Label(dialogArea, 0);
        label.setText("Filtering script");
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\t\tnode being tested (null if object is not a node).\r\n\t$object\t\tobject being tested.\r\n\t$dci\t\t\tDCI object being tested.\r\n\t$service\tcurrent business service this check belongs to.\r\n\r\nReturn value: true to bind dci to this business service, false to unbind, null to make no changes.");
        this.filterSource.setText(this.businessService.getDciAutoBindFilter());
        this.filterSource.setEnabled(this.businessService.isDciAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    private boolean applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final boolean apply = this.checkboxEnableBind.getSelection();
        final boolean remove = this.checkboxEnableUnbind.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialStatusThreshold == this.thresholdCombo.getSelectionIndex() && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.businessService.getObjectId());
        md.setAutoBindFilter2(this.filterSource.getText());
        int flags = this.businessService.getAutoBindFlags();
        flags = apply ? flags | 4 : flags & 0xFFFFFFFB;
        flags = remove ? flags | 8 : flags & 0xFFFFFFF7;
        md.setAutoBindFlags(Integer.valueOf(flags));
        md.setObjectStatusThreshold(Integer.valueOf(this.thresholdCombo.getSelectionIndex()));
        new ConsoleJob("Update auto-bind filter", null, "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                DCIAutoBind.this.initialBind = apply;
                DCIAutoBind.this.initialUnbind = remove;
                DCIAutoBind.this.initialAutoBindFilter = md.getAutoBindFilter();
                DCIAutoBind.this.initialStatusThreshold = md.getObjectStatusThreshold();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DCIAutoBind.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot change DCI automatic bind options for business service";
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkboxEnableBind.setSelection(false);
        this.checkboxEnableUnbind.setSelection(false);
        this.filterSource.setText("");
    }
}

