/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.PassiveRackElementType;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class RackPassiveElementEditDialog
extends Dialog {
    private static final String[] ORIENTATION = new String[]{"Fill", "Front", "Rear"};
    private static final String[] TYPE = new String[]{"Patch panel", "Filler panel", "Organiser", "PDU"};
    private PassiveRackElement element;
    private LabeledText name;
    private Combo type;
    private Combo orientation;
    private LabeledSpinner position;
    private LabeledSpinner height;
    private String title;
    private ImageSelector frontImage;
    private ImageSelector rearImage;

    public RackPassiveElementEditDialog(Shell parentShell, PassiveRackElement element) {
        super(parentShell);
        this.element = element != null ? element : new PassiveRackElement();
        this.title = element == null ? "Add Element" : "Edit Element";
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.numColumns = 4;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.element.getName());
        this.name.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Type", (Object)gd);
        this.type.setItems(TYPE);
        this.type.setText(TYPE[this.element.getType().getValue()]);
        this.position = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.position.setLabel(Messages.RackPlacement_Position);
        this.position.setRange(1, 50);
        this.position.setSelection(this.element.getPosition());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.position.setLayoutData((Object)gd);
        this.height = new LabeledSpinner(dialogArea, 0);
        this.height.setLabel("Height");
        this.height.setRange(1, 50);
        this.height.setSelection(this.element.getHeight());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.height.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.orientation = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Orientation", (Object)gd);
        this.orientation.setItems(ORIENTATION);
        this.orientation.setText(ORIENTATION[this.element.getOrientation().getValue()]);
        this.orientation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RackOrientation o = RackOrientation.getByValue((int)RackPassiveElementEditDialog.this.orientation.getSelectionIndex());
                RackPassiveElementEditDialog.this.frontImage.setEnabled(o == RackOrientation.FRONT || o == RackOrientation.FILL);
                RackPassiveElementEditDialog.this.rearImage.setEnabled(o == RackOrientation.REAR || o == RackOrientation.FILL);
            }
        });
        this.frontImage = new ImageSelector(dialogArea, 0);
        this.frontImage.setLabel("Front image");
        this.frontImage.setImageGuid(this.element.getFrontImage(), true);
        this.frontImage.setEnabled(this.element.getOrientation() == RackOrientation.FRONT || this.element.getOrientation() == RackOrientation.FILL);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.frontImage.setLayoutData((Object)gd);
        this.rearImage = new ImageSelector(dialogArea, 0);
        this.rearImage.setLabel("Rear image");
        this.rearImage.setImageGuid(this.element.getRearImage(), true);
        this.rearImage.setEnabled(this.element.getOrientation() == RackOrientation.REAR || this.element.getOrientation() == RackOrientation.FILL);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.rearImage.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.element.setPosition(this.position.getSelection());
        this.element.setHeight(this.height.getSelection());
        this.element.setOrientation(RackOrientation.getByValue((int)this.orientation.getSelectionIndex()));
        this.element.setName(this.name.getText());
        this.element.setType(PassiveRackElementType.getByValue((int)this.type.getSelectionIndex()));
        this.element.setFrontImage(this.frontImage.getImageGuid());
        this.element.setRearImage(this.rearImage.getImageGuid());
        super.okPressed();
    }

    public PassiveRackElement getElement() {
        return this.element;
    }
}

