/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.console.resources.DataCollectionDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditColumnDialog
extends Dialog {
    private ColumnDefinition column;
    private LabeledText name;
    private LabeledText displayName;
    private Combo dataType;
    private Combo aggregationFunction;
    private Button checkInstanceColumn;
    private Button checkSnmpHexString;
    private LabeledText snmpOid;
    private static final DataType[] TYPES = new DataType[]{DataType.INT32, DataType.UINT32, DataType.COUNTER32, DataType.INT64, DataType.UINT64, DataType.COUNTER64, DataType.FLOAT, DataType.STRING};

    public EditColumnDialog(Shell parentShell, ColumnDefinition column) {
        super(parentShell);
        this.column = column;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.column.getName().isEmpty() ? "Add Column Definition" : "Edit Column Definition ");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.EditColumnDialog_Name);
        this.name.setText(this.column.getName());
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.displayName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.displayName.setLabel(Messages.EditColumnDialog_DispName);
        this.displayName.setText(this.column.getDisplayName());
        this.displayName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Messages.get();
        this.dataType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.EditColumnDialog_DataType, (Object)new GridData(4, 0x1000000, true, false));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.FLOAT));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.STRING));
        this.dataType.select(EditColumnDialog.getDataTypePosition(this.column.getDataType()));
        Messages.get();
        this.aggregationFunction = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.EditColumnDialog_AggFunc, (Object)new GridData(4, 0x1000000, true, false));
        Messages.get();
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_SUM);
        Messages.get();
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_AVG);
        Messages.get();
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_MIN);
        Messages.get();
        this.aggregationFunction.add(Messages.TableColumnLabelProvider_MAX);
        this.aggregationFunction.select(this.column.getAggregationFunction());
        this.checkInstanceColumn = new Button(dialogArea, 32);
        Messages.get();
        this.checkInstanceColumn.setText(Messages.EditColumnDialog_InstanceCol);
        this.checkInstanceColumn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkInstanceColumn.setSelection(this.column.isInstanceColumn());
        this.checkSnmpHexString = new Button(dialogArea, 32);
        this.checkSnmpHexString.setText("Convert SNMP value to &hexadecimal string");
        this.checkSnmpHexString.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkSnmpHexString.setSelection(this.column.isConvertSnmpStringToHex());
        this.snmpOid = new LabeledText(dialogArea, 0);
        Messages.get();
        this.snmpOid.setLabel(Messages.EditColumnDialog_SNMP_OID);
        this.snmpOid.setText(this.column.getSnmpObjectId() != null ? this.column.getSnmpObjectId().toString() : "");
        this.snmpOid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        String oidText = this.snmpOid.getText().trim();
        if (!oidText.isEmpty()) {
            try {
                SnmpObjectId oid = SnmpObjectId.parseSnmpObjectId((String)oidText);
                this.column.setSnmpObjectId(oid);
            }
            catch (SnmpObjectIdFormatException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.EditColumnDialog_Warning, (String)Messages.EditColumnDialog_InvalidOID);
                return;
            }
        } else {
            this.column.setSnmpObjectId(null);
        }
        if (this.name.getText().trim().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Column name can not be empty");
            return;
        }
        this.column.setName(this.name.getText().trim());
        this.column.setDisplayName(this.displayName.getText().trim().isEmpty() ? this.name.getText().trim() : this.displayName.getText().trim());
        this.column.setInstanceColumn(this.checkInstanceColumn.getSelection());
        this.column.setConvertSnmpStringToHex(this.checkSnmpHexString.getSelection());
        this.column.setDataType(EditColumnDialog.getDataTypeByPosition(this.dataType.getSelectionIndex()));
        this.column.setAggregationFunction(this.aggregationFunction.getSelectionIndex());
        super.okPressed();
    }

    private static int getDataTypePosition(DataType type) {
        switch (type) {
            case COUNTER32: {
                return 2;
            }
            case COUNTER64: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case INT32: {
                return 0;
            }
            case INT64: {
                return 3;
            }
            case STRING: {
                return 7;
            }
            case UINT32: {
                return 1;
            }
            case UINT64: {
                return 4;
            }
        }
        return 0;
    }

    private static DataType getDataTypeByPosition(int position) {
        return TYPES[position];
    }
}

